/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.ws.cloudn;


/**
 * cloudn に登録されているネットワーク情報。
 *
 */
public class Network {
	private String networkId = "";
	private String name = "";
	private String vpcId = "";
	private String cidrBlock = "";
	private String availabilityZone = "";

	/**
	 * ネットワーク ID を取得する。
	 * 
	 * @return ネットワーク ID。
	 */
	public String getNetworkId() {
		return networkId;
	}

	/**
	 * ネットワーク ID を設定する。
	 * 
	 * @param networkId ネットワークID。
	 */
	public void setNetworkId(String networkId) {
		this.networkId = networkId;
	}

	/**
	 * ネットワーク名を取得する。
	 * 
	 * @return ネットワーク名。
	 */
	public String getName() {
		return name;
	}

	/**
	 * ネットワーク名を設定する。
	 * 
	 * @param name ネットワーク名。
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * ネットワークが所属する VPC ID を取得する。
	 * 
	 * @return VPC ID。
	 */
	public String getVpcId() {
		return vpcId;
	}

	/**
	 * ネットワークが所属する VPC ID を設定する。
	 * 
	 * @param vpcId
	 */
	public void setVpcId(String vpcId) {
		this.vpcId = vpcId;
	}

	/**
	 * ネットワークのサイダーを取得する。
	 * 
	 * @return ネットワークのサイダー。
	 */
	public String getCidrBlock() {
		return cidrBlock;
	}

	/**
	 * ネットワークのサイダーを設定する。
	 * 
	 * @param cidrBlock ネットワークのサイダー。
	 */
	public void setCidrBlock(String cidrBlock) {
		this.cidrBlock = cidrBlock;
	}

	/**
	 * ネットワークが所属するゾーンを取得する。
	 * 
	 * @return ゾーン。
	 */
	public String getAvailabilityZone() {
		return availabilityZone;
	}

	/**
	 * ネットワークが所属するゾーンを設定する。
	 * 
	 * @param availabilityZone ゾーン。
	 */
	public void setAvailabilityZone(String availabilityZone) {
		this.availabilityZone = availabilityZone;
	}
}
