/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.rest;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;

import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(false)
@XmlRootElement(name="virtualmachine")
public class VirtualMachine {
	public String id;
	public String name;
	public String displayname;
	public String account;
	public String domainid;
	public String domain;
	public String created;
	public String state;
	public boolean haenable;
	public String groupid;
	public String group;
	public String zoneid;
	public String zonename;
	public String templateid;
	public String templatename;
	public String templatedisplaytext;
	public boolean passwordenabled;
	public String password;
	public String serviceofferingid;
	public String serviceofferingname;
	public int cpunumber;
	public int cpuspeed;
	public int memory;
	public String guestosid;
	public int rootdeviceid;
	public String rootdevicetype;
	public List<Nic> nic = new ArrayList<>();
	public String hypervisor;
	public List<Tag> tags = new ArrayList<>();
	public boolean displayvm;
	public boolean isdynamicallyscalable;
	public String jobid;
	public String jobstatus;
	
	// FLAT
	public String cpuused;
	public String isodisplaytext;
	public String isoid;
	public String isoname;
	public String networkkbsread;
	public String networkkbswrite;
	public List<SecurityGroup> securitygroup;
}
