/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.rest;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

import com.clustercontrol.cloud.cloudn.rest.api.MarshalParam;
import com.google.common.base.Preconditions;

@NonNullByDefault(false)
@MarshalParam
public class ListOsTypesRequest extends RestApplicationRequest {
	public String description; // list os by descriptionfalse
	public String id; // list by Os type Idfalse
	public String keyword; // List by keywordfalse
	public String oscategoryid; // list by Os Category idfalse
	public String page; // false
	public String pagesize; // false
	
	public ListOsTypesRequest withId(@NonNull String id) {
		Preconditions.checkNotNull(id);
		this.id = id;
		return this;
	}
}