/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.rest;

import org.eclipse.jdt.annotation.NonNullByDefault;

import com.clustercontrol.cloud.cloudn.rest.api.MarshalParam;

@NonNullByDefault(false)
@MarshalParam
public class DeployVirtualMachineRequest extends RestApplicationRequest {
	// 仮想マシンのスペックを確定するために、serviceOfferingIdを指定する
	public String serviceofferingid = ""; // 必須
	// 仮想マシンを作成する際に利用するテンプレートのID、またはISO ImageのIDを指定する
	public String templateid = ""; // 必須
	// 仮想マシンを作成するゾーンを指定する
	public String zoneid = ""; // 必須
	// domainidと共に使用して、任意のアカウントを指定する 
	public String account;
	// diskofferingidを指定する。templateidがISO imageのIDの場合は、指定したdiskofferingidをもつDISKは
	// root DISKに、templateidで指定したIDがテンプレートであれば、Data DISKとして作成される 
	public String diskofferingid;
	// 仮想マシンの任意の表示名 
	public String displayname;
	// domainid を指定する。accountと同時に指定する
	public String domainid;
	// 仮想マシンに任意のグループを設定する 
	public String group;
	// 仮想マシンのキーボードタイプを指定する。 指定出来る値は、de,de-ch,es,fi,fr,fr-be,fr-ch,is,it,jp,nl-be,no,pt,uk及びusのいずれか。 
	public String keyboard;
	// logiin時に利用するsshのkeypairの名前を指定する 
	public String keypair;
	// 仮想マシンに任意の名前を設定する。 
	public String name;
	// 任意のデータをbase64でエンコードして指定する（base64 encode後 2KBまで） 
	public String userdata;
	
	//VPC
	public final String hypervisor = "kvm"; // 必須
	public String networkids = ""; // 必須
	public String usedata;
	
	//FLAT
	// 仮想マシンに適用するセキュリティーグループのIDを指定する。複数指定する場合は、カンマ（,）区切りで指定する。このパラメータを指定する場合は、” securitygroupnames”を指定することが出来ない。
	public String securitygroupids;
	// 仮想マシンに適用するセキュリティーグループの名前を指定する。複数指定する場合は、カンマ（,）区切りで指定する。このパラメータを指定する場合は、” securitygroupids”を指定することが出来ない。 
	public String securitygroupnames;

	// その他
	public String iptonetworklist;
	public String affinitygroupnames;
	public String ipaddress;
	public String affinitygroupids;
	public String projectid;
	public String ip6address;
	public Boolean displayvm;
	public String size;
	public Boolean startvm;
	public String hostid;
}