/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.factory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.persistence.Query;

import com.clustercontrol.cloud.ICloudContext;
import com.clustercontrol.cloud.IResourceManagement.Storage;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.PluginFault;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudStorage;
import com.clustercontrol.cloud.cloudn.factory.CloudnResourceManagement_VPC.BackupedStorageDetail;
import com.clustercontrol.cloud.dao.CloudStorageBackupDao;
import com.clustercontrol.cloud.dao.CloudStorageDao;
import com.clustercontrol.cloud.factory.IStorageOperator;
import com.clustercontrol.cloud.factory.ResourceStore;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.persistence.TransactionException;
import com.clustercontrol.cloud.registry.AbstractObjectChangedListener;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;

public class MigrationProcesser extends AbstractObjectChangedListener<CloudStorage> {
	public static class StorageMigration {
		private CloudStorageDao from_;
		private Storage to_;

		public StorageMigration() {
		}

		public StorageMigration(CloudStorageDao from, Storage to) {
			this.from_ = from;
			this.to_ = to;
		}
		
		public CloudStorageDao getFrom() {
			return from_;
		}

		public Storage getTo() {
			return to_;
		}
		
		public StorageMigration from(CloudStorageDao from) {
			this.from_ = from;
			return this;
		}
		public StorageMigration to(Storage to) {
			this.to_ = to;
			return this;
		}
	}
	
	public static class StorageMigrationHolder {
		private Map<String, StorageMigration> map = Collections.synchronizedMap(new HashMap<String, StorageMigration>());
		public void add(StorageMigration m) {
			map.put(m.getFrom().getStorageId(), m);
		}
		public boolean isEmpty() {
			return map.isEmpty();
		}
		public StorageMigration of(String fromStorageId) {
			return map.get(fromStorageId);
		}
	}
	
	@Override
	public void preRemoved(String eventName, CloudStorage object) throws PluginFault {
		// 以下の処理の前提としては、CloudStorageDao の追加削除は、追加が必ず先に行われること。
		// CloudStorageDao の削除が先だと、マイグレーションによるバックアップ情報の移行先の CloudStorageDao ができていないため、
		// 削除対象の　CloudStorageDao が先に削除されると、バックアップ情報も一緒に削除されてしまう。
		StorageMigrationHolder holder = SessionService.current().get(StorageMigrationHolder.class);
		StorageMigration migration;
		if (holder == null || holder.isEmpty() || (migration = holder.of(object.getStorageId())) == null) return;
		
		ICloudContext context = SessionService.current().get(ICloudContext.class);
		ResourceStore store = new ResourceStore(
									context.getAccessDestionation().getCloudAccountResource().getAccountResourceId(),
									context.getAccessDestionation().getCloudAccountResource().getCloudServiceId(),
									context.getCurrentRegion().getRegion());
		
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		if (em.find(CloudStorageDao.class, new CloudStorageDao.CloudStoragePK(migration.getTo().getStorageId(), context.getCurrentRegion().getRegion(), context.getAccessDestionation().getCloudAccountResource().getAccountResourceId())) == null) {
			IStorageOperator operator = ObjectRegistryService.registry().get(IStorageOperator.class);
			operator.setAccessDestination(context.getAccessDestionation());
			operator.setCloudRegion(context.getCurrentRegion());
			try {
				Method m = operator.getClass().getDeclaredMethod("transactionalInternalUpdate", String.class, CloudStorageDao.class, Storage.class);
				m.invoke(operator, context.getCurrentRegion().getRegion(), null, migration.getTo());
			} catch (NoSuchMethodException | SecurityException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
				throw new InternalManagerError(e);
			}
		}
		
		Query query = em.createQuery("SELECT b FROM CloudStorageBackupDao b JOIN CloudAccountResourceDao a ON b.accountResourceId = a.accountResourceId JOIN CloudRegionDao r ON a.cloudServiceId = r.cloudServiceId " +
				"WHERE a.accountResourceId = :accountResourceId AND r.region = :region AND b.backupedData.storageId = :target");
		query.setParameter("accountResourceId", context.getAccessDestionation().getCloudAccountResource().getAccountResourceId());
		query.setParameter("region", context.getCurrentRegion().getRegion());
		query.setParameter("target", migration.getFrom().getStorageId());

		@SuppressWarnings("unchecked")
		List<CloudStorageBackupDao> backups = new ArrayList<>((List<CloudStorageBackupDao>)query.getResultList());
		ObjectMapper om = new ObjectMapper();
		ObjectReader or = om.reader(BackupedStorageDetail.class);
		ObjectWriter ow = om.writerWithType(BackupedStorageDetail.class);
		for (CloudStorageBackupDao b: backups) {
//			if (b.getBackupedData().getStorageId().equals(object.getStorageId())) {
				try {
					Storage s = migration.getTo();
					String backupDetail = store.get(CloudnResourceManagement_VPC.RT_StorageBackup, b.getStorageBackupId());
					if (backupDetail != null) {
						BackupedStorageDetail backuped = or.readValue(backupDetail);
						if (s.getZone().equals(backuped.zone)) {
							backuped.storageId = s.getStorageId();
							store.put(CloudnResourceManagement_VPC.RT_StorageBackup, b.getStorageBackupId(), ow.writeValueAsString(backuped));
						}
					}
					b.getBackupedData().setStorageId(s.getStorageId());
				}
				catch (Exception e) {
					throw new TransactionException(e);
				}
//			}
		}
	}
}