/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.validation;

import java.lang.reflect.Method;
import java.util.Map;

import com.clustercontrol.cloud.IMessagesHolder;

public interface EntityValidator {
	public interface PropValidatorInfo {
		String propName();
		String elementId();
		Method getMethod();
		void validate(Object property, String group, IMessagesHolder messages) throws ValidationFault;
	}

	public interface EntityValidationContext {
		Class<?> ｔype();
		void validate(Object entity, String group, IMessagesHolder messages) throws ValidationFault;
		PropValidatorInfo getPropValidator(String propName);
		Map<String, PropValidatorInfo> getPropValidatorMap();
		CustomEntityValidator<?> getCustomEntityValidator();
	}

	void validate(Object entity, String group) throws ValidationFault;

//	EntityContext getEntityContext(Class<?> type);
}
