/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.ws.cloudn;

import com.clustercontrol.accesscontrol.bean.PrivilegeConstant;
import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ICloudContext;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.Tag;
import com.clustercontrol.cloud.cloudn.factory.CloudnAsynchJobTrackingOperator;
import com.clustercontrol.cloud.cloudn.rest.CloudnCompute;
import com.clustercontrol.cloud.cloudn.rest.ListNetworksResponse;
import com.clustercontrol.cloud.cloudn.rest.ListSecurityGroupsResponse;
import com.clustercontrol.cloud.cloudn.rest.ResetPasswordForVirtualMachineResponse;
import com.clustercontrol.cloud.cloudn.rest.api.RestfulApplicationException;
import com.clustercontrol.cloud.cloudn.util.CloudnConstants;
import com.clustercontrol.cloud.cloudn.util.CloudnUtil;
import com.clustercontrol.cloud.factory.CloudRoleConstants;
import com.clustercontrol.cloud.util.Tuple;
import com.clustercontrol.cloud.validation.AuthorizingValidator_role_region;
import com.clustercontrol.cloud.validation.annotation.CustomMethodValidation;
import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.Size;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidUserPass;
import com.clustercontrol.ws.cloud.IWebServiceBase;
import com.clustercontrol.ws.cloud.security.HinemosAccessRight;
import com.clustercontrol.ws.cloudn.AttachStorageResult;
import com.clustercontrol.ws.cloudn.CloudnOptionEndpoint;
import com.clustercontrol.ws.cloudn.DeleteInstanceResult;
import com.clustercontrol.ws.cloudn.Network;
import com.clustercontrol.ws.cloudn.PasswordResult;
import com.clustercontrol.ws.cloudn.SecurityGroup;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import org.eclipse.jdt.annotation.NonNull;

@WebService(serviceName="CloudnOptionEndpointService", portName="CloudnOptionEndpointPort", targetNamespace="http://cloudn.ws.clustercontrol.com", endpointInterface="com.clustercontrol.ws.cloudn.CloudnOptionEndpoint")
public class CloudnOptionEndpointImpl
implements CloudnOptionEndpoint,
IWebServiceBase,
CloudnConstants,
CloudRoleConstants {
    @NonNull
    protected CloudnCompute getCloudnEndpoint() throws CloudManagerFault {
        ICloudContext context = (ICloudContext)SessionService.current().get(ICloudContext.class);
        return CloudnUtil.getCloudnEndpoint(CloudnCompute.class, context.getAccessDestionation().getCloudUser().getAccessKey(), context.getAccessDestionation().getCloudUser().getSecretKey(), context.getCurrentRegion().getEndpoint("compute").getLocation());
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public List<Network> getNetworks(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        try {
            ArrayList<Network> networks = new ArrayList<Network>();
            ListNetworksResponse res = this.getCloudnEndpoint().listNetworks();
            for (com.clustercontrol.cloud.cloudn.rest.Network net : res.network) {
                Network network = new Network();
                network.setName(net.name);
                network.setNetworkId(net.id);
                network.setVpcId(net.vpcid);
                network.setAvailabilityZone(net.zonename);
                network.setCidrBlock(net.cidr);
                networks.add(network);
            }
            return networks;
        }
        catch (RestfulApplicationException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    public void start() {
    }

    public void stop() {
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public List<SecurityGroup> getSecurityGroups(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        try {
            ArrayList<SecurityGroup> securityGroups = new ArrayList<SecurityGroup>();
            ListSecurityGroupsResponse res = this.getCloudnEndpoint().listSecurityGroups(null);
            for (com.clustercontrol.cloud.cloudn.rest.SecurityGroup restSecurityGroup : res.securitygroup) {
                SecurityGroup securityGroup = new SecurityGroup();
                securityGroup.setName(restSecurityGroup.name);
                securityGroup.setId(restSecurityGroup.id);
                securityGroup.setDescription(restSecurityGroup.description);
                if (restSecurityGroup.tags != null && !restSecurityGroup.tags.isEmpty()) {
                    securityGroup.setTags(new ArrayList<Tag>());
                    for (com.clustercontrol.cloud.cloudn.rest.Tag tag : restSecurityGroup.tags) {
                        securityGroup.getTags().add(new Tag(tag.key, tag.value));
                    }
                }
                securityGroups.add(securityGroup);
            }
            return securityGroups;
        }
        catch (RestfulApplicationException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.EXEC})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public void resetPassword(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="instanceId") @NotNull String instanceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        try {
            ResetPasswordForVirtualMachineResponse response = this.getCloudnEndpoint().resetPasswordForVirtualMachine(instanceId);
            CloudnAsynchJobTrackingOperator.registJobId(Tuple.build((Object[])new Object[]{"getPassword", instanceId, this.getAccountResourceId()}), response.jobid);
        }
        catch (RestfulApplicationException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public PasswordResult getPassword(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="instanceId") @NotNull String instanceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        try {
            String jobId = CloudnAsynchJobTrackingOperator.findJobId(Tuple.build((Object[])new Object[]{"getPassword", instanceId, this.getAccountResourceId()}));
            return CloudnAsynchJobTrackingOperator.getJobResult(this.getCloudnEndpoint(), jobId, PasswordResult.class);
        }
        catch (RestfulApplicationException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public AttachStorageResult getAttachStorageResult(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="storageId") @NotNull String storageId, @ElementId(value="instanceId") @NotNull String instanceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        try {
            String jobId = CloudnAsynchJobTrackingOperator.findJobId(Tuple.build((Object[])new Object[]{"getAttachStorageResult", storageId, instanceId, this.getAccountResourceId()}));
            return CloudnAsynchJobTrackingOperator.getJobResult(this.getCloudnEndpoint(), jobId, AttachStorageResult.class);
        }
        catch (RestfulApplicationException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public DeleteInstanceResult getDeleteInstanceResult(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="instanceId") @NotNull String instanceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        try {
            String jobId = CloudnAsynchJobTrackingOperator.findJobId(Tuple.build((Object[])new Object[]{"getDeleteInstanceResult", instanceId, this.getAccountResourceId()}));
            return CloudnAsynchJobTrackingOperator.getJobResult(this.getCloudnEndpoint(), jobId, DeleteInstanceResult.class);
        }
        catch (RestfulApplicationException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    private String getAccountResourceId() {
        return ((ICloudContext)SessionService.current().get(ICloudContext.class)).getAccessDestionation().getCloudAccountResource().getAccountResourceId();
    }
}

