/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.util;

import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Cider {
    private static final Pattern ciderPattern = Pattern.compile("^(\\d{1,3}+)\\.(\\d{1,3}+)\\.(\\d{1,3}+)\\.(\\d{1,3}+)/(\\d{1,2}+)$");
    private static final Pattern ipPattern = Pattern.compile("^(\\d{1,3}+)\\.(\\d{1,3}+)\\.(\\d{1,3}+)\\.(\\d{1,3}+)$");
    private int network;
    private int mask;

    public Cider(String cider) throws UnknownHostException {
        Matcher m = ciderPattern.matcher(cider);
        if (!m.matches()) {
            throw new UnknownHostException("cider is of illegal format");
        }
        this.network = Cider.ofIpaddress(new byte[]{Cider.toByte(m.group(1)), Cider.toByte(m.group(2)), Cider.toByte(m.group(3)), Cider.toByte(m.group(4))});
        this.mask = Cider.ofMask(Byte.parseByte(m.group(5)));
    }

    private static int ofIpaddress(Inet4Address ipaddress) {
        return Cider.ofIpaddress(ipaddress.getAddress());
    }

    private static int ofIpaddress(byte[] bytes) {
        int address = bytes[3] & 0xFF;
        address |= bytes[2] << 8 & 0xFF00;
        address |= bytes[1] << 16 & 0xFF0000;
        return address |= bytes[0] << 24 & 0xFF000000;
    }

    private static int ofMask(byte mask) {
        byte[] masks = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int check = mask - 8 * (i + 1);
            masks[i] = (byte)(check > 0 ? 255 : (int)Cider.makeBitPattern(8 + check));
            if (check < 0) break;
        }
        return Cider.ofIpaddress(masks);
    }

    private static byte toByte(String value) {
        int intValue = Integer.parseInt(value);
        if (intValue > 127) {
            return (byte)(intValue - 256);
        }
        return (byte)intValue;
    }

    private static byte makeBitPattern(int check) {
        byte result = 0;
        for (int i = 0; i < Math.min(check, 8); ++i) {
            result = (byte)(result | 1 << 8 - i - 1);
        }
        return result;
    }

    public boolean matches(Inet4Address addr) {
        return (Cider.ofIpaddress(addr) & this.mask) == this.network;
    }

    public boolean matches(String addr) {
        Matcher m = ipPattern.matcher(addr);
        if (!m.matches()) {
            return false;
        }
        return (Cider.ofIpaddress(new byte[]{Cider.toByte(m.group(1)), Cider.toByte(m.group(2)), Cider.toByte(m.group(3)), Cider.toByte(m.group(4))}) & this.mask) == this.network;
    }
}

