/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.validation;

import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.validation.ContainerValidator;
import com.clustercontrol.cloud.validation.CustomMethodValidator;
import com.clustercontrol.cloud.validation.MethodValidator;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.cloud.validation.ValidationUtil;
import com.clustercontrol.cloud.validation.Validator;
import com.clustercontrol.cloud.validation.annotation.CustomMethodValidation;
import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.ValidatedBy;
import com.clustercontrol.cloud.validation.annotation.ValidationGroup;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MethodValidatorImpl
implements MethodValidator {
    private Map<Method, MethodValidator.MethodValidationContext> validationContextMap = new HashMap<Method, MethodValidator.MethodValidationContext>();
    private static Method initMethod;
    private static Method validateMethod;

    @Override
    public void validate(Method method, Object[] params) throws ValidationFault {
        MethodValidator.MethodValidationContext validationContext = this.getMethodContext(method);
        if (validationContext != null) {
            validationContext.validate(params, ValidationUtil.getMessages());
            CustomMethodValidator[] cvs = validationContext.getCustomMethodValidators();
            if (cvs != null) {
                try {
                    for (CustomMethodValidator cv : cvs) {
                        this.getValidateMethod().invoke((Object)cv, method, params, validationContext.validationGroup(), ValidationUtil.getMessages(), validationContext);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof ValidationFault) {
                        throw (ValidationFault)e.getCause();
                    }
                    if (e.getCause() instanceof IllegalStateException) {
                        throw (IllegalStateException)e.getCause();
                    }
                    throw new IllegalStateException(e.getCause());
                }
            }
        }
    }

    @Override
    public MethodValidator.MethodValidationContext getMethodContext(Method method) {
        MethodValidator.MethodValidationContext validationContext = this.validationContextMap.get(method);
        if (validationContext == null) {
            ValidationGroup vga;
            Logger logger = Logger.getLogger(MethodValidatorImpl.class);
            logger.debug((Object)("checking : " + method.getName()));
            MethodContextImpl mc = null;
            CustomMethodValidation c = method.getAnnotation(CustomMethodValidation.class);
            if (c != null) {
                mc = new MethodContextImpl();
                mc.setMethod(method);
                ArrayList<CustomMethodValidator> cmList = new ArrayList<CustomMethodValidator>();
                try {
                    Class<? extends CustomMethodValidator>[] cmClazzes;
                    for (Class<? extends CustomMethodValidator> cmClazz : cmClazzes = c.value()) {
                        cmList.add(cmClazz.newInstance());
                    }
                }
                catch (Exception e) {
                    if (e instanceof IllegalStateException) {
                        throw (IllegalStateException)e;
                    }
                    throw new IllegalStateException(e);
                }
                mc.setMethodCustomValidators(cmList.toArray(new CustomMethodValidator[cmList.size()]));
            }
            if (method.getParameterAnnotations().length > 0 && mc == null) {
                mc = new MethodContextImpl();
                mc.setMethod(method);
            }
            if (mc != null && (vga = method.getAnnotation(ValidationGroup.class)) != null) {
                mc.setValidationGroup(vga.value());
            }
            StringBuilder elementIdBuilder = new StringBuilder();
            elementIdBuilder.append(Character.toLowerCase(method.getDeclaringClass().getSimpleName().charAt(0)) + method.getDeclaringClass().getSimpleName().substring(1));
            elementIdBuilder.append('.');
            elementIdBuilder.append(Character.toLowerCase(method.getName().charAt(0)) + method.getName().substring(1));
            for (Class<?> clazz : method.getParameterTypes()) {
                elementIdBuilder.append('_');
                elementIdBuilder.append(Character.toLowerCase(clazz.getSimpleName().charAt(0)) + clazz.getSimpleName().substring(1));
            }
            String elementId = elementIdBuilder.toString();
            Annotation[][] annotationss = method.getParameterAnnotations();
            for (int i = 0; i < annotationss.length; ++i) {
                ElementId eid = null;
                ArrayList<Validator> list = new ArrayList<Validator>();
                ArrayList<ContainerValidator> containerList = new ArrayList<ContainerValidator>();
                for (Annotation anno : annotationss[i]) {
                    logger.debug((Object)("annotation : " + anno.annotationType().getName()));
                    ValidatedBy vb = anno.annotationType().getAnnotation(ValidatedBy.class);
                    if (vb != null) {
                        Class<?> validatorClass = vb.value();
                        logger.debug((Object)("validator : " + validatorClass.getName()));
                        try {
                            Validator paramValidator = (Validator)validatorClass.newInstance();
                            this.getInitMethod().invoke((Object)paramValidator, anno);
                            if (paramValidator.getElementId() == null || paramValidator.getElementId().equals("")) {
                                paramValidator.setElementId(elementId + "." + i);
                            }
                            if (paramValidator instanceof ContainerValidator) {
                                containerList.add((ContainerValidator)paramValidator);
                                continue;
                            }
                            list.add(paramValidator);
                            continue;
                        }
                        catch (Exception e) {
                            if (e instanceof IllegalStateException) {
                                throw (IllegalStateException)e;
                            }
                            throw new IllegalStateException(e);
                        }
                    }
                    if (anno.annotationType() != ElementId.class) continue;
                    eid = (ElementId)ElementId.class.cast(anno);
                }
                if (eid != null) {
                    for (Validator v : list) {
                        v.setElementId(eid.value());
                    }
                    for (ContainerValidator v : containerList) {
                        v.setElementId(eid.value());
                    }
                }
                ParamValidatorInfoImpl pvm = new ParamValidatorInfoImpl();
                pvm.setValidators(list.toArray(new Validator[0]));
                pvm.setContainerValidators(containerList.toArray(new ContainerValidator[0]));
                pvm.setType(method.getParameterTypes()[i]);
                mc.addPropValidator(pvm);
            }
            if (mc != null) {
                this.validationContextMap.put(method, mc);
            }
            validationContext = mc;
        }
        return validationContext;
    }

    private Method getInitMethod() {
        if (initMethod == null) {
            try {
                initMethod = Validator.class.getDeclaredMethod("init", Annotation.class);
            }
            catch (Exception e) {
                if (e instanceof IllegalStateException) {
                    throw (IllegalStateException)e;
                }
                throw new IllegalStateException(e);
            }
        }
        return initMethod;
    }

    private Method getValidateMethod() {
        if (validateMethod == null) {
            try {
                validateMethod = CustomMethodValidator.class.getDeclaredMethod("validate", Method.class, Object[].class, String.class, IMessagesHolder.class, MethodValidator.MethodValidationContext.class);
            }
            catch (Exception e) {
                if (e instanceof IllegalStateException) {
                    throw (IllegalStateException)e;
                }
                throw new IllegalStateException(e);
            }
        }
        return validateMethod;
    }

    private static class MethodContextImpl
    implements MethodValidator.MethodValidationContext {
        private Method method;
        private String validationGroup;
        private List<MethodValidator.ParamValidatorInfo> validatorList = new ArrayList<MethodValidator.ParamValidatorInfo>();
        private CustomMethodValidator[] customMethodValidators;

        private MethodContextImpl() {
        }

        @Override
        public Method method() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        @Override
        public CustomMethodValidator[] getCustomMethodValidators() {
            return this.customMethodValidators;
        }

        public void setMethodCustomValidators(CustomMethodValidator[] customMethodValidators) {
            this.customMethodValidators = customMethodValidators != null ? customMethodValidators : new CustomMethodValidator[]{};
        }

        @Override
        public void validate(Object[] params, IMessagesHolder messages) throws ValidationFault {
            if (params.length != this.validatorList.size()) {
                throw new IllegalStateException();
            }
            for (int i = 0; i < this.validatorList.size(); ++i) {
                this.validatorList.get(i).validate(params[i], this.validationGroup, messages);
            }
        }

        @Override
        public MethodValidator.ParamValidatorInfo[] getPropValidators() {
            return this.validatorList.toArray(new MethodValidator.ParamValidatorInfo[0]);
        }

        public void addPropValidator(MethodValidator.ParamValidatorInfo validator) {
            this.validatorList.add(validator);
        }

        @Override
        public String validationGroup() {
            return this.validationGroup;
        }

        public void setValidationGroup(String validationGroup) {
            this.validationGroup = validationGroup;
        }
    }

    private static class ParamValidatorInfoImpl
    implements MethodValidator.ParamValidatorInfo {
        private Method validateMethod;
        private Validator<? extends Annotation, ?>[] validators;
        private TypeKind typeKind;
        private ContainerValidator<? extends Annotation, ?>[] containerValidators;

        private ParamValidatorInfoImpl() {
        }

        @Override
        public void validate(Object param, String group, IMessagesHolder messages) throws ValidationFault {
            switch (this.typeKind) {
                case Array: 
                case List: {
                    try {
                        for (Validator<? extends Annotation, ?> validator : this.containerValidators) {
                            this.getValidateMethod().invoke(validator, param, group, messages);
                        }
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (InvocationTargetException e) {
                        if (e.getCause() instanceof ValidationFault) {
                            throw (ValidationFault)e.getCause();
                        }
                        if (e.getCause() instanceof IllegalStateException) {
                            throw (IllegalStateException)e.getCause();
                        }
                        throw new IllegalStateException(e.getCause());
                    }
                }
            }
            block16: for (Validator<? extends Annotation, ?> validator : this.validators) {
                try {
                    switch (this.typeKind) {
                        case List: {
                            if (param == null) continue block16;
                            for (Object element : (List)param) {
                                this.getValidateMethod().invoke(validator, element, group, messages);
                            }
                            continue block16;
                        }
                        case Array: {
                            if (param == null) continue block16;
                            for (Object element : (Object[])param) {
                                this.getValidateMethod().invoke(validator, element, group, messages);
                            }
                            continue block16;
                        }
                        default: {
                            this.getValidateMethod().invoke(validator, param, group, messages);
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof ValidationFault) {
                        throw (ValidationFault)e.getCause();
                    }
                    if (e.getCause() instanceof IllegalStateException) {
                        throw (IllegalStateException)e.getCause();
                    }
                    throw new IllegalStateException(e.getCause());
                }
            }
        }

        public void setValidators(Validator<?, ?>[] validators) {
            this.validators = validators;
        }

        public void setContainerValidators(ContainerValidator<?, ?>[] containerValidators) {
            this.containerValidators = containerValidators;
        }

        public void setType(Class<?> returnType) {
            this.typeKind = List.class.isAssignableFrom(returnType) ? TypeKind.List : (returnType.isArray() ? TypeKind.Array : TypeKind.Simple);
        }

        private Method getValidateMethod() {
            if (this.validateMethod == null) {
                try {
                    this.validateMethod = Validator.class.getDeclaredMethod("validate", Object.class, String.class, IMessagesHolder.class);
                }
                catch (Exception e) {
                    if (e instanceof IllegalStateException) {
                        throw (IllegalStateException)e;
                    }
                    throw new IllegalStateException(e);
                }
            }
            return this.validateMethod;
        }

        private static enum TypeKind {
            Simple,
            Array,
            List;

        }
    }
}

