/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class PluginBaseMessages {
    private static final String RESOURCE_BUNDLE = "com.clustercontrol.cloud.plugin_base_messages";
    private static ResourceBundle m_bundle = ResourceBundle.getBundle("com.clustercontrol.cloud.plugin_base_messages");

    private PluginBaseMessages() {
    }

    public static ResourceBundle getBundle() {
        return m_bundle;
    }

    public static String getString(String key, Object ... args) {
        MessageFormat messageFormat = new MessageFormat(PluginBaseMessages.getString(key));
        return messageFormat.format(args);
    }

    public static String getString(String key) {
        try {
            return m_bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String getString(String key, String def) {
        try {
            return m_bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return def;
        }
    }

    public static String getString(String key, Object[] args, Locale locale) {
        return MessageFormat.format(PluginBaseMessages.getString(key, locale), args);
    }

    public static String getString(String key, Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale);
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String getString(String key, String def, Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale);
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return def;
        }
    }
}

