/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud;

import com.clustercontrol.cloud.IMessagesHolder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MultiBundleHolder
implements IMessagesHolder {
    private Map<String, String> messageMap = new HashMap<String, String>();
    private List<ResourceBundle> bundles = new ArrayList<ResourceBundle>();

    public MultiBundleHolder(String ... resourceNames) {
        for (String resourceName : resourceNames) {
            ResourceBundle bundle = ResourceBundle.getBundle(resourceName);
            this.bundles.add(bundle);
        }
    }

    public void addBundle(String resourceName) {
        ResourceBundle bundle = ResourceBundle.getBundle(resourceName);
        this.bundles.add(bundle);
    }

    @Override
    public String getString(String key, Object ... args) {
        MessageFormat messageFormat = new MessageFormat(this.getString(key));
        return messageFormat.format(args);
    }

    @Override
    public String getString(String key) {
        return this.getString(key, key);
    }

    @Override
    public String getString(String key, String def) {
        String message = this.messageMap.get(key);
        if (message != null) {
            return message;
        }
        for (ResourceBundle bundle : this.bundles) {
            try {
                message = bundle.getString(key);
                break;
            }
            catch (MissingResourceException e) {
            }
        }
        message = message == null ? (def == null ? key : def) : message;
        this.messageMap.put(key, message);
        return message;
    }
}

