/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory.monitors;

import com.clustercontrol.accesscontrol.session.AccessControllerBean;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.HinemosCredential;
import com.clustercontrol.cloud.ICloudOption;
import com.clustercontrol.cloud.Messages;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudAccountResource;
import com.clustercontrol.cloud.bean.CloudService;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.commons.CloudConstants;
import com.clustercontrol.cloud.commons.CloudPropertyConstants;
import com.clustercontrol.cloud.factory.IAccountResourceOperator;
import com.clustercontrol.cloud.factory.ICloudServiceOperator;
import com.clustercontrol.cloud.factory.ICloudUserOperator;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.CloudCredential;
import com.clustercontrol.cloud.util.CloudMessageUtil;
import com.clustercontrol.cloud.util.HinemosUtil;
import com.clustercontrol.cloud.util.RepositoryControllerBeanWrapper;
import com.clustercontrol.commons.util.HinemosSessionContext;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.monitor.plugin.model.MonitorPluginInfoEntity;
import com.clustercontrol.monitor.plugin.model.MonitorPluginStringInfoEntity;
import com.clustercontrol.monitor.plugin.util.QueryUtil;
import com.clustercontrol.monitor.run.bean.MonitorRunResultInfo;
import com.clustercontrol.monitor.run.factory.RunMonitor;
import com.clustercontrol.monitor.run.factory.RunMonitorNumericValueType;
import com.clustercontrol.notify.bean.OutputBasicInfo;
import com.clustercontrol.notify.session.NotifyControllerBean;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.session.RepositoryControllerBean;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CloudServiceBillingMonitor
extends RunMonitorNumericValueType {
    private static Log m_log = LogFactory.getLog(RunMonitor.class);
    public static final String monitorTypeId = "MON_BILLING";
    public static final int monitorType = 1;
    public static final String key_target = "target";
    private MonitorPluginInfoEntity m_plugin = null;
    private List<MonitorPluginStringInfoEntity> m_monitorPluginStringInfoList;
    private String m_message = null;
    private String m_messageOrg = null;

    public boolean collect(String facilityId) {
        try {
            String userId = CloudPropertyConstants.internal_thread_admin_user.value();
            HinemosSessionContext.instance().setProperty("loginUserId", (Object)userId);
            SessionService.current().setHinemosCredential(new HinemosCredential(userId));
            HinemosSessionContext.instance().setProperty("isAdministrator", (Object)new AccessControllerBean().isAdministrator());
            NodeInfo node = RepositoryControllerBeanWrapper.bean().getNode(facilityId);
            String accountResourceId = node.getCloudAccountResouce();
            if (accountResourceId == null) {
                this.m_messageOrg = this.m_message = ErrorCode.MONITOR_MISSING_ACCOUNTRESOURCEID.getMessage(accountResourceId);
                return false;
            }
            IAccountResourceOperator accountResourceOperator = (IAccountResourceOperator)ObjectRegistryService.registry().get(IAccountResourceOperator.class);
            CloudAccountResource accountResource = accountResourceOperator.findCloudAccountResource(accountResourceId);
            ICloudServiceOperator serviceOperator = (ICloudServiceOperator)ObjectRegistryService.registry().get(ICloudServiceOperator.class);
            CloudService cloudService = serviceOperator.findCloudService(accountResource.getCloudServiceId());
            String target = null;
            for (MonitorPluginStringInfoEntity entry : this.m_monitorPluginStringInfoList) {
                if (!key_target.equals(entry.getId().getKey())) continue;
                target = entry.getValue();
                break;
            }
            ICloudUserOperator userOperator = (ICloudUserOperator)ObjectRegistryService.registry().get(ICloudUserOperator.class);
            CloudUser cloudUser = userOperator.findCloudUser(accountResource.getAccountId());
            ICloudOption cloudOption = (ICloudOption)ObjectRegistryService.registry().get(ICloudOption.class, (Object)cloudService.getCloudTypeId());
            cloudOption.setCredential(new CloudCredential(cloudUser));
            ICloudOption.Billing billing = cloudOption.getBillingForCloudService(target);
            if (billing != null) {
                this.m_message = Messages.messages().getString("cloud.billingalarm.message.notify", new Object[]{String.valueOf(billing.getPrice())});
                this.m_messageOrg = Messages.messages().getString("cloud.billingalarm.message.notify.org", new Object[]{String.valueOf(billing.getPrice()), CloudConstants.time_format.format(billing.getUpdateDate().getTime())});
                this.m_nodeDate = billing.getUpdateDate().getTime();
                this.m_value = billing.getPrice();
                return true;
            }
            this.m_messageOrg = this.m_message = Messages.messages().getString("cloud.billingalarm.message.notify.no_data", new Object[]{target});
            if (this.m_now != null) {
                this.m_nodeDate = this.m_now.getTime();
            }
            return false;
        }
        catch (Exception e) {
            this.m_message = e.getMessage();
            this.m_messageOrg = e.getMessage() + "\n" + CloudMessageUtil.getExceptionStackTrace(e);
            return false;
        }
    }

    protected void setCheckInfo() throws MonitorNotFound {
        this.m_plugin = QueryUtil.getMonitorPluginInfoPK((String)this.m_monitorId);
        this.m_monitorPluginStringInfoList = this.m_plugin.getMonitorPluginStringInfoEntities();
    }

    protected RunMonitor createMonitorInstance() throws HinemosUnknown {
        return new CloudServiceBillingMonitor();
    }

    public String getMessageId(int key) {
        HinemosUtil.Priority priority = HinemosUtil.Priority.priority((int)key);
        return priority == null ? "100" : priority.messageId;
    }

    public String getMessage(int key) {
        return this.m_message;
    }

    public String getMessageOrg(int key) {
        return this.m_messageOrg;
    }

    protected void notify(boolean isNode, String facilityId, int result, Date generationDate, MonitorRunResultInfo resultInfo) throws HinemosUnknown {
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("notify() isNode = " + isNode + ", facilityId = " + facilityId + ", result = " + result + ", generationDate = " + generationDate.toString() + ", resultInfo = " + resultInfo.getMessage()));
        }
        Integer monitorFlg = 0;
        monitorFlg = this.m_monitor.getMonitorFlg();
        if (monitorFlg == 0) {
            m_log.debug((Object)("notify() isNode = " + isNode + ", facilityId = " + facilityId + ", result = " + result + ", generationDate = " + generationDate.toString() + ", resultInfo = " + resultInfo.getMessage() + ", monitorFlg is false"));
            return;
        }
        String notifyGroupId = resultInfo.getNotifyGroupId();
        if (notifyGroupId == null || "".equals(notifyGroupId)) {
            return;
        }
        OutputBasicInfo notifyInfo = new OutputBasicInfo();
        notifyInfo.setPluginId(this.m_monitorTypeId);
        notifyInfo.setMonitorId(this.m_monitorId);
        notifyInfo.setApplication(this.m_monitor.getApplication());
        String facilityPath = new RepositoryControllerBean().getFacilityPath(facilityId, null);
        notifyInfo.setFacilityId(facilityId);
        notifyInfo.setScopeText(facilityPath);
        int priority = -1;
        String messageId = "";
        String message = "";
        String messageOrg = "";
        if (isNode) {
            priority = resultInfo.getPriority();
            messageId = resultInfo.getMessageId();
            message = resultInfo.getMessage();
            messageOrg = resultInfo.getMessageOrg();
        } else {
            priority = result;
            messageId = this.getMessageIdForScope(result);
            message = this.getMessageForScope(result);
            messageOrg = this.getMessageOrgForScope(result);
        }
        notifyInfo.setPriority(priority);
        notifyInfo.setMessageId(messageId);
        String target = null;
        for (MonitorPluginStringInfoEntity entry : this.m_monitorPluginStringInfoList) {
            if (!key_target.equals(entry.getId().getKey())) continue;
            target = entry.getValue();
            break;
        }
        notifyInfo.setSubKey(target);
        notifyInfo.setMessage(message);
        notifyInfo.setMessageOrg(messageOrg);
        if (generationDate != null) {
            notifyInfo.setGenerationDate(Long.valueOf(generationDate.getTime()));
        }
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("notify() priority = " + priority + " , messageId = " + messageId + " , message = " + message + " , messageOrg = " + messageOrg + ", generationDate = " + generationDate));
        }
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("sending message : priority=" + notifyInfo.getPriority() + " generationDate=" + notifyInfo.getGenerationDate() + " pluginId=" + notifyInfo.getPluginId() + " monitorId=" + notifyInfo.getMonitorId() + " facilityId=" + notifyInfo.getFacilityId() + " subKey=" + notifyInfo.getSubKey() + ")"));
        }
        new NotifyControllerBean().notify(notifyInfo, notifyGroupId);
    }
}

