/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.IAccessDestination;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.bean.CloudAccountResource;
import com.clustercontrol.cloud.bean.CloudRegion;
import com.clustercontrol.cloud.bean.CloudService;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.factory.IResourceOperatorBase;
import com.clustercontrol.cloud.factory.ResourceStore;
import com.clustercontrol.cloud.persistence.Transactional;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.CloudCredential;
import com.clustercontrol.cloud.util.ResourceRegion;
import org.apache.log4j.Logger;

public abstract class ResourceOperatorBase
implements IResourceOperatorBase {
    private IAccessDestination accessDestination;
    private CloudRegion cloudRegion;
    private IResourceManagement resourceManagement;
    private Logger logger;

    @Override
    @Transactional(value=Transactional.TransactionType.Supported)
    public void setAccessDestination(IAccessDestination accessDestination) throws CloudManagerFault {
        this.accessDestination = accessDestination;
    }

    protected CloudUser getCloudUser() {
        return this.accessDestination.getCloudUser();
    }

    protected CloudService getCloudService() {
        return this.accessDestination.getCloudService();
    }

    protected CloudAccountResource getAccountResource() {
        return this.accessDestination.getCloudAccountResource();
    }

    protected CloudRegion getCloudRegion() {
        return this.cloudRegion;
    }

    protected IResourceManagement getResourceManagement() throws CloudManagerFault {
        if (this.resourceManagement == null) {
            this.resourceManagement = (IResourceManagement)ObjectRegistryService.registry().get(IResourceManagement.class, (Object)this.getCloudService().getCloudTypeId());
            if (this.resourceManagement == null) {
                throw new InternalManagerError();
            }
            this.resourceManagement.setAccessDestination(new CloudCredential(this.getCloudUser()), new ResourceRegion(this.getCloudRegion()));
            this.resourceManagement.setStore(new ResourceStore(this.getAccountResource().getAccountResourceId(), this.getAccountResource().getCloudServiceId(), this.getCloudRegion().getRegion()));
        }
        return this.resourceManagement;
    }

    protected <T extends IResourceOperatorBase> T getResourceOperator(Class<T> clazz) throws CloudManagerFault {
        IResourceOperatorBase operator = (IResourceOperatorBase)ObjectRegistryService.registry().get(clazz);
        operator.setAccessDestination(this.accessDestination);
        operator.setCloudRegion(this.cloudRegion);
        return (T)operator;
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.getClass());
        }
        return this.logger;
    }

    @Override
    public void setCloudRegion(CloudRegion cloudRegion) throws CloudManagerFault {
        this.cloudRegion = cloudRegion;
    }
}

