/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

import com.clustercontrol.util.Messages;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.ICloudInstanceBackup;


public class DeleteInstanceBackupAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.DeleteImage";

	private MessageManager messages = MessageManager.getInstance("messages");
	
	private String strImageId = messages.getString("word.image_id");
	private String msgDeleteInstanceBackupConfirm = messages.getString("message.confirm_some_action_to_subjects", new Object[]{"word.instance_backup", "word.remove"});
	private String msgDeleteInstanceBackupResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.instance_backup", "word.remove"});

	@Override
	protected void invoke(IAction action) throws InvocationException {
		ICloudInstanceBackup backup = (ICloudInstanceBackup)((IStructuredSelection)viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();

		if (MessageDialog.openConfirm(
			null,
			Messages.getString("confirmed"),
			msgDeleteInstanceBackupConfirm + "\n" + strImageId + " = " + backup.getInstanceBackupId())
		){
			backup.getCloudInstanceBackupManager().removeCloudInstanceBackup(backup.getInstanceBackupId());

			// 成功報告ダイアログを生成
			MessageDialog.openInformation(
				null,
				Messages.getString("successful"),
				msgDeleteInstanceBackupResult);

		}
		else {
			return;
		}
	}
}