/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views;

import java.util.concurrent.ThreadPoolExecutor;

public abstract class AsyncUpdateViewPart extends AbstractCloudViewPart {
	interface DataHolder<T, S> {
		S getTargetState();
		S getCurrentState();
		T asyncGetData(S targetState) throws Exception;
		boolean isInitialized(S targetState);
		boolean prepare();
		void startAsyncCall(S targetState);
		void failAsyncCall(S targetState, Exception exception);
		void failPrepareAsyncCall(Exception exception);
		void syncSetData(S targetState, T data);
		void success();
		void error(Exception exception);
	}
	
	protected <T, S> void update(final DataHolder<T, S> item, final boolean force) {
		S targetState = null;
		try {
			if (!item.prepare()) {
				return;
			}
			
			// 現在、選択項目に合わせた表示内容を決定。
			targetState = item.getTargetState();
			
			// 表示する項目がない。あるいは、同じリージョンが対象の場合は、非同期処理をしない。
			if (targetState == null || (!force && item.isInitialized(targetState))) {
				item.success();
				return;
			}
			
			item.startAsyncCall(targetState);
		}
		catch (Exception e) {
			item.failPrepareAsyncCall(e);
			return;
		}
		
		// Region は内部クラスなので、キャストは、非同期に関わるここだけの処理。
		final S fTargetState = targetState;

		// 未実行のタスクは削除。
		getExecutor().getQueue().clear();
		
		Runnable runnable = new Runnable() {
			@Override
			public void run() {
				T data = null;
				Exception exception = null;
				if (!item.isInitialized(fTargetState) || force) {
					try {
						data = item.asyncGetData(fTargetState);
					}
					catch (Exception e) {
						exception = e;
						e.printStackTrace();
					}
				}
				final T fData = data;
				final Exception fException = exception;

				// UI スレッドで、取得した情報の同期。
				getViewSite().getShell().getDisplay().asyncExec(
					new Runnable() {
						@Override
						public void run() {
							Exception exception = fException;
							if (exception == null) {
								try {
									if (fData != null) {
										item.syncSetData(fTargetState, fData);
									}
									else {
										throw new NullPointerException();
									}
								}
								catch (Exception e) {
									exception = e;
									item.failAsyncCall(fTargetState, exception);
								}
							}
							else {
								item.failAsyncCall(fTargetState, exception);
							}

							if (item.getTargetState() == fTargetState) {
								if (exception == null) {
									item.success();
								}
								else {
									item.error(exception);
								}
							}
						}
					});
				}
			};
		
		// 非同期処理実施
		getExecutor().execute(runnable);
	}
	
	public abstract void update();

	protected abstract ThreadPoolExecutor getExecutor();
}
