/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.presenter;


public interface IScope extends IFacility {
	// プロパティの Id
	interface p2 {
		static final PropertyId2<CollectionObserver2<IScope>> scopes = new PropertyId2<CollectionObserver2<IScope>>();
		static final PropertyId2<CollectionObserver2<INode>> nodes = new PropertyId2<CollectionObserver2<INode>>();
	}
	
	enum ScopeType {
		root,
		account_resource_list,
		account_resource_group,
		account_resource_scope{
			public String getAccountResourceId(IScope scope){
				return scope.getFacilityId().replace("_Scope", "");
			}
		},
		region{
			public String getAccountResourceId(IScope scope){
				return scope.getParent().getFacilityId().replace("_Scope", "");
			}
			public String getRegion(IScope scope){
				return scope.getFacilityId().replace(getAccountResourceId(scope) + "_", "");
			}
		},
		zone{
			public String getAccountResourceId(IScope scope){
				return scope.getParent().getParent().getFacilityId().replace("_Scope", "");
			}
			public String getRegion(IScope scope){
				return scope.getParent().getFacilityId().replace(getAccountResourceId(scope) + "_", "");
			}
		},
		;
		
		public String getAccountResourceId(IScope scope){return null;};
		public String getRegion(IScope scope){return null;};
	}

	ScopeType getScopeType();
	IScope[] getScopes();
	INode[] getNodes();
}
