/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.base.ui.views.actions;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.cloudn.base.resources.Filter;
import com.clustercontrol.cloud.cloudn.base.resources.Template;
import com.clustercontrol.cloud.cloudn.base.resources.Zone;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.CreateTemplateDialog;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.SelectVMIDialog;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudTemplate;
import com.clustercontrol.cloud.presenter.ModifyCloudTemplateRequest;
import com.clustercontrol.cloud.ui.views.TemplatesView;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;

public class ModifyTemplateAction
extends SingleSelectionActionEx {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgModifyTemplateConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.template", "word.modify"});
    private String msgModifyTemplateResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.template", "word.modify"});
    private CloudResourceProvider provider;
    private ICloudTemplate template;

    protected void invoke(IAction action) throws InvocationException {
        this.template = (ICloudTemplate)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        final IAccountResource accountResource = ((TemplatesView)this.viewPart).getAccountResource();
        this.provider = new CloudResourceProviderImpl(accountResource.getAccountResourceId());
        final CreateTemplateDialog dialog = new CreateTemplateDialog(this.viewPart.getSite().getShell());
        dialog.setCloudInfoProvider(this.provider);
        try {
            dialog.setBehavior(new CreateTemplateDialog.IDialogBehavior(){

                @Override
                public void setup(final CreateTemplateDialog.DialogControlContainer container) {
                    ArrayList templateJobs;
                    MessageManagerExt messages = MessageManagerExt.getInstance("messages");
                    container.getCmbZone().addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            container.getTxtVmi().setText("");
                            container.getTxtVmi().setData(null);
                            container.getTxtVmi().setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                        }
                    });
                    container.getCmbRegion().addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            this.setupZone(container);
                        }
                    });
                    try {
                        templateJobs = TemplateJobUtil.getTemplateJobList((String)accountResource.getAccountResourceId(), (Boolean)true);
                    }
                    catch (Exception e) {
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)e.getMessage());
                        templateJobs = new ArrayList();
                    }
                    for (String regionName : ModifyTemplateAction.this.provider.getAllRegion()) {
                        String regionLocaleName = messages.getString(regionName);
                        container.getCmbRegion().add(regionLocaleName);
                        container.getCmbRegion().setData(regionLocaleName, (Object)regionName);
                    }
                    if (ModifyTemplateAction.this.template != null && ModifyTemplateAction.this.template.getRegion() != null && !ModifyTemplateAction.this.template.getRegion().equals("")) {
                        String regionLocaleName = messages.getString(ModifyTemplateAction.this.template.getRegion());
                        container.getCmbRegion().select(container.getCmbRegion().indexOf(regionLocaleName));
                    } else {
                        container.getCmbRegion().select(0);
                    }
                    final Shell shell = dialog.getShell();
                    container.getBtnSelectVmi().addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            List<Template> officials = ModifyTemplateAction.this.provider.getTemplates("jp-e1", Arrays.asList(new Filter("category", "official"), new Filter("zone", container.getCmbZone().getText())));
                            List<Template> mys = ModifyTemplateAction.this.provider.getTemplates("jp-e1", Arrays.asList(new Filter("category", "my"), new Filter("zone", container.getCmbZone().getText())));
                            SelectVMIDialog dialog = new SelectVMIDialog(officials, mys, shell);
                            if (dialog.open() == 0) {
                                Template output = dialog.getOutput();
                                container.getTxtVmi().setText(output.getName() + " ( " + output.getId() + " ) ");
                                container.getTxtVmi().setData((Object)output);
                            }
                        }
                    });
                    if (ModifyTemplateAction.this.template != null) {
                        container.getTxtTemplateId().setText(ModifyTemplateAction.this.template.getTemplateId());
                        container.getTxtTemplateId().setEditable(false);
                    }
                    if (ModifyTemplateAction.this.template != null && ModifyTemplateAction.this.template.getTemplateName() != null && !ModifyTemplateAction.this.template.getTemplateName().isEmpty()) {
                        container.getTxtTemplateName().setText(ModifyTemplateAction.this.template.getTemplateName());
                    }
                    if (ModifyTemplateAction.this.template != null && ModifyTemplateAction.this.template.getImageId() != null && !ModifyTemplateAction.this.template.getImageId().equals("") && ModifyTemplateAction.this.template.getRegion() != null && !ModifyTemplateAction.this.template.getRegion().equals("")) {
                        Filter f1 = new Filter();
                        f1.setName("image-id");
                        f1.setValues(Arrays.asList(ModifyTemplateAction.this.template.getImageId()));
                        Filter f2 = new Filter();
                        f2.setName("zone");
                        f2.setValues(Arrays.asList(ModifyTemplateAction.this.template.getImageId().substring(37)));
                        List<Template> imageList = ModifyTemplateAction.this.provider.getTemplates(ModifyTemplateAction.this.template.getRegion(), Arrays.asList(f1, f2));
                        if (!imageList.isEmpty()) {
                            Template image = imageList.get(0);
                            container.getCmbZone().select(container.getCmbZone().indexOf(image.getId().substring(37)));
                            container.getTxtVmi().setText(image.getName() + " ( " + image.getId() + " ) ");
                            container.getTxtVmi().setData((Object)image);
                            container.getTxtVmi().setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                        }
                    }
                    HashMap<String, String> tmpMap = new HashMap<String, String>();
                    for (TemplateJobUtil.TemplateJobnet childJobItem : templateJobs) {
                        String jobId = childJobItem.getJobnetId();
                        String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
                        tmpMap.put(jobId, jobName);
                        container.getCmbLaunchJobId().add(jobName);
                        container.getCmbLaunchJobId().setData(jobName, (Object)jobId);
                        container.getCmbStartJobId().add(jobName);
                        container.getCmbStartJobId().setData(jobName, (Object)jobId);
                        container.getCmbStopJobId().add(jobName);
                        container.getCmbStopJobId().setData(jobName, (Object)jobId);
                    }
                    if (ModifyTemplateAction.this.template != null && ModifyTemplateAction.this.template.getLaunchJobId() != null && !ModifyTemplateAction.this.template.getLaunchJobId().equals("") && tmpMap.containsKey(ModifyTemplateAction.this.template.getLaunchJobId())) {
                        container.getCmbLaunchJobId().select(container.getCmbLaunchJobId().indexOf((String)tmpMap.get(ModifyTemplateAction.this.template.getLaunchJobId())));
                    }
                    if (ModifyTemplateAction.this.template != null && ModifyTemplateAction.this.template.getStartJobId() != null && !ModifyTemplateAction.this.template.getStartJobId().equals("") && tmpMap.containsKey(ModifyTemplateAction.this.template.getStartJobId())) {
                        container.getCmbStartJobId().select(container.getCmbStartJobId().indexOf((String)tmpMap.get(ModifyTemplateAction.this.template.getStartJobId())));
                    }
                    if (ModifyTemplateAction.this.template != null && ModifyTemplateAction.this.template.getStopJobId() != null && !ModifyTemplateAction.this.template.getStopJobId().equals("") && tmpMap.containsKey(ModifyTemplateAction.this.template.getStopJobId())) {
                        container.getCmbStopJobId().select(container.getCmbStopJobId().indexOf((String)tmpMap.get(ModifyTemplateAction.this.template.getStopJobId())));
                    }
                }

                private void setupZone(CreateTemplateDialog.DialogControlContainer container) {
                    container.getCmbZone().removeAll();
                    for (Zone zone : ModifyTemplateAction.this.provider.getZones((String)container.getCmbRegion().getData(container.getCmbRegion().getText()))) {
                        container.getCmbZone().add(zone.getName());
                        container.getCmbZone().setData(zone.getName(), (Object)zone);
                    }
                    if (container.getCmbZone().getItemCount() > 0) {
                        container.getCmbZone().select(0);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new InvocationException((Throwable)e);
        }
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgModifyTemplateConfirm)) {
                ModifyCloudTemplateRequest request = new ModifyCloudTemplateRequest();
                request.setImageId(dialog.getOutput().getImageId());
                request.setJobUnitId(this.template.getJobUnitId());
                request.setLaunchJobId(dialog.getOutput().getLaunchJobId());
                request.setStartJobId(dialog.getOutput().getStartJobId());
                request.setStopJobId(dialog.getOutput().getStopJobId());
                request.setRegion(dialog.getOutput().getRegion());
                request.setTemplateId(dialog.getOutput().getTemplateId());
                request.setTemplateName(dialog.getOutput().getTemplateName());
                this.template.modifyCloudTemplate(request);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgModifyTemplateResult);
            } else {
                return;
            }
        }
    }
}

