/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.dialogs;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.ValidateException;
import com.clustercontrol.cloud.commons.util.annotation.RequiredSelect;
import com.clustercontrol.cloud.presenter.ICloudUser;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class ChangeActiveCloudUserDialog
extends Dialog {
    private DialogOutput output = new DialogOutput();
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private String strSeparator = this.bundle_messages.getString("caption.title_separator");
    private String strAccountResource = this.bundle_messages.getString("word.account_resource");
    private String strActiveUser = this.bundle_messages.getString("word.cloud_user");
    private Text txtAccountResource;
    @RequiredSelect(value="strActiveUser")
    private Combo cmbCloudUser;
    private IDialogBehavior behavior = new DialogBehavior();

    public ChangeActiveCloudUserDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 4);
        container.setBackground(SWTResourceManager.getColor(22));
        GridLayout gl_container = new GridLayout(2, false);
        gl_container.verticalSpacing = 15;
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(4, 4, true, false);
        container.setLayoutData((Object)gd_container);
        Label lblAccountResource = new Label(container, 0);
        lblAccountResource.setText(this.strAccountResource + this.strSeparator);
        lblAccountResource.setLayoutData((Object)new GridData(4, 4, false, true));
        this.txtAccountResource = new Text(container, 2048);
        this.txtAccountResource.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lblCloudUser = new Label(container, 0);
        lblCloudUser.setText(this.strActiveUser + this.strSeparator);
        lblCloudUser.setLayoutData((Object)new GridData(4, 4, false, true));
        this.cmbCloudUser = new Combo(container, 8);
        this.cmbCloudUser.setLayoutData((Object)new GridData(4, 4, false, true));
        this.behavior.setupAccountResource(this.txtAccountResource);
        this.behavior.setupCloudUser(this.cmbCloudUser);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(480, 240);
    }

    protected void okPressed() {
        try {
            ControlUtil.validate(this);
        }
        catch (ValidateException e) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)e.getMessage());
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.output.setCloudUser((ICloudUser)this.cmbCloudUser.getData(this.cmbCloudUser.getText()));
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.bundle_messages.getString("caption.change_active_cloud_user_dialog"));
    }

    public DialogOutput getOutput() {
        return this.output;
    }

    public void setBehavior(IDialogBehavior behavior) {
        this.behavior = behavior;
    }

    public static class DialogOutput {
        private ICloudUser cloudUser;

        public ICloudUser getCloudUser() {
            return this.cloudUser;
        }

        public void setCloudUser(ICloudUser cloudUser) {
            this.cloudUser = cloudUser;
        }
    }

    public static class DialogBehavior
    implements IDialogBehavior {
        @Override
        public void setupAccountResource(Text txtAccountResource) {
            txtAccountResource.setEditable(false);
        }

        @Override
        public void setupCloudUser(Combo cmbCloudUser) {
        }
    }

    public static interface IDialogBehavior {
        public void setupAccountResource(Text var1);

        public void setupCloudUser(Combo var1);
    }
}

