/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.plugin.monitor;

import com.clustercontrol.cloud.plugin.monitor.FacilityTreeComposite;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ScopeTreeDialog
extends CommonDialog {
    private FacilityTreeComposite treeComposite = null;
    private boolean scopeOnly;
    private boolean unregistered;
    private boolean selectNodeOnly;
    private String ownerRoleId = null;

    public ScopeTreeDialog(Shell parent, String ownerRoleId) {
        super(parent);
        this.ownerRoleId = ownerRoleId;
        this.scopeOnly = false;
        this.unregistered = false;
    }

    public ScopeTreeDialog(Shell parent, String ownerRoleId, boolean scopeOnly) {
        super(parent);
        this.ownerRoleId = ownerRoleId;
        this.scopeOnly = scopeOnly;
        this.unregistered = false;
    }

    public ScopeTreeDialog(Shell parent, String ownerRoleId, boolean scopeOnly, boolean unregistered) {
        super(parent);
        this.ownerRoleId = ownerRoleId;
        this.scopeOnly = scopeOnly;
        this.unregistered = unregistered;
    }

    public void setSelectNodeOnly(boolean flag) {
        this.selectNodeOnly = flag;
    }

    protected Point getInitialSize() {
        return new Point(400, 400);
    }

    protected void customizeDialog(Composite parent) {
        parent.getShell().setText(Messages.getString((String)"select.scope"));
        GridLayout layout = new GridLayout(5, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.treeComposite = this.selectNodeOnly ? new FacilityTreeComposite(parent, 0, this.ownerRoleId, false, false, false, "CloudAccountResourceList") : new FacilityTreeComposite(parent, 0, this.ownerRoleId, this.scopeOnly, this.unregistered, false, "CloudAccountResourceList");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        this.treeComposite.setLayoutData(gridData);
        this.treeComposite.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ScopeTreeDialog.this.okPressed();
            }
        });
    }

    public FacilityTreeItem getSelectItem() {
        return this.treeComposite.getSelectItem();
    }

    protected ValidateResult validate() {
        ValidateResult result = null;
        FacilityTreeItem item = this.getSelectItem();
        if (this.selectNodeOnly) {
            if (item == null || item.getData().isNotReferFlg().booleanValue() || item.getData().getFacilityType() == 2 || item.getData().getFacilityType() == 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.repository.2"));
            }
        } else if (item == null || item.getData().isNotReferFlg().booleanValue() || item.getData().getFacilityType() == 2) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.repository.47"));
        }
        return result;
    }

    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }
}

