/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.commons.util;

import com.clustercontrol.cloud.Activator;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParameterManager {
    private static final Map<String, ParameterManager> instances = new HashMap<String, ParameterManager>();
    private List<String> internalList;
    private Map<String, String> internalMap;
    private Map<String, String> reverseMap;

    private ParameterManager(String parameterName) {
        this.internalList = this.getInternalList(parameterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParameterManager getInstance(String parameterName) {
        ParameterManager pm = null;
        Map<String, ParameterManager> map = instances;
        synchronized (map) {
            if (instances.containsKey(parameterName)) {
                pm = instances.get(parameterName);
            } else {
                pm = new ParameterManager(parameterName);
                instances.put(parameterName, pm);
            }
        }
        return pm;
    }

    public static Object getOnlyValue(String key) {
        ParameterManager manager = ParameterManager.getInstance(key);
        return manager.getList().get(0);
    }

    public String getValue(String key) {
        return this.getMap().get(key);
    }

    public List<String> getList() {
        return new ArrayList<String>(this.internalList);
    }

    public Map<String, String> getMap() {
        if (this.internalMap == null) {
            this.internalMap = new LinkedHashMap<String, String>();
            for (String tempStr : this.internalList) {
                String value;
                String key;
                if (tempStr.indexOf("=") != -1) {
                    int delimiterIndex = tempStr.indexOf("=");
                    key = tempStr.substring(0, delimiterIndex);
                    value = tempStr.indexOf("=") != tempStr.length() - 1 ? tempStr.substring(delimiterIndex + 1) : "";
                } else {
                    key = tempStr;
                    value = "";
                }
                this.internalMap.put(key, value);
            }
        }
        return new LinkedHashMap<String, String>(this.internalMap);
    }

    public Map<String, String> getReverseMap() {
        if (this.reverseMap == null) {
            this.reverseMap = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> entry : this.getMap().entrySet()) {
                this.reverseMap.put(entry.getValue(), entry.getKey());
            }
        }
        return new LinkedHashMap<String, String>(this.reverseMap);
    }

    private List<String> getInternalList(String parameterName) {
        BufferedReader buffer = null;
        try {
            String tempString;
            FileReader file = new FileReader(Activator.getPluginPath() + "\\resources\\" + "parameter");
            buffer = new BufferedReader(file);
            Boolean readOn = false;
            Boolean inCommentOut = false;
            Pattern pattern = Pattern.compile("\\{.*\\}");
            Pattern commentOut = Pattern.compile("[ \\t]*//");
            Pattern commnetOutStart = Pattern.compile("[ \\t]*/\\*");
            Pattern commnetOutEnd = Pattern.compile("\\*/[ \\t]*");
            ArrayList<String> list = new ArrayList<String>();
            while ((tempString = buffer.readLine()) != null) {
                Matcher matcher;
                if (!inCommentOut.booleanValue()) {
                    matcher = commnetOutStart.matcher(tempString);
                    if (matcher.find()) {
                        int start = matcher.start();
                        matcher = commnetOutEnd.matcher(tempString);
                        if (matcher.find()) {
                            tempString = tempString.substring(0, start) + tempString.substring(matcher.end());
                        } else {
                            tempString = tempString.substring(0, start);
                            inCommentOut = true;
                        }
                    }
                } else {
                    matcher = commnetOutEnd.matcher(tempString);
                    if (!matcher.find()) continue;
                    tempString = tempString.substring(matcher.end());
                    inCommentOut = false;
                }
                if ((matcher = commentOut.matcher(tempString)).find()) {
                    tempString = tempString.substring(0, matcher.start());
                }
                if (readOn.booleanValue()) {
                    matcher = pattern.matcher(tempString);
                    if (matcher.find()) break;
                    if (tempString.equals("")) continue;
                    list.add(tempString);
                    continue;
                }
                if (!tempString.equals("{" + parameterName + "}")) continue;
                readOn = true;
            }
            if (list.isEmpty()) {
                throw new Exception("Parameter " + parameterName + " can't read in the parameter file.");
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (buffer != null) {
                try {
                    buffer.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

