package com.clustercontrol.systemlog.util;

import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.systemlog.factory.SelectMonitorSystemlog;

/**
 * システムログ監視のキャッシュ
 *
 * 
 * @version 4.0.2
 * @since 4.0.2
 */
public class SystemlogCache {
	private static Log m_log = LogFactory.getLog( SystemlogCache.class );

	private static Object lock = new Object();
	private static ArrayList<MonitorInfo> systemLogMonitorCache = null;

	public static void clear() {
		synchronized (lock) {
			m_log.info("reset systemLogMonitorCache");
			systemLogMonitorCache = null;
		}
	}
	/**
	 * システムログ監視一覧リストを返します。
	 * 
	 * @return Objectの2次元配列
	 * @throws MonitorNotFound
	 * @throws HinemosUnknown
	 */
	public static ArrayList<MonitorInfo> getSystemlogList() throws MonitorNotFound, HinemosUnknown{
		synchronized (lock) {
			if (systemLogMonitorCache == null) {
				long startTime = System.currentTimeMillis();
				int size = 0;
				m_log.debug("systemLogMonitorCache is empty");
				SelectMonitorSystemlog systemlog = new SelectMonitorSystemlog();
				try {
					systemLogMonitorCache = systemlog.getMonitorList(HinemosModuleConstant.MONITOR_SYSTEMLOG);
					size = systemLogMonitorCache.size();
				} catch (MonitorNotFound e) {
					throw e;
				} catch (Exception e) {
					m_log.error("getSystemlogList " + e.getMessage(), e);
					throw new HinemosUnknown(e.getMessage(), e);
				}
				long endTime = System.currentTimeMillis();
				m_log.info("refresh SystemLogMonitorCache. " + (endTime - startTime)
						+ "ms. size=" + size);
				return systemLogMonitorCache;
			}else{
				m_log.debug("systemLogMonitorCache is not empty");
				return systemLogMonitorCache;
			}
		}
	}

}
