/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */
package com.clustercontrol.snmptrap.message;

import java.io.Serializable;
import java.util.Date;

/**
 * SNMPトラップ通知情報のメッセージクラス<BR>
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class SnmpTrapMessageInfo implements Serializable{

	private static final long serialVersionUID = -2671112668006652920L;

	private String m_monitorId;
	private String m_facilityId;
	private String m_agentAdder;
	private Date m_trapDate;
	private String m_communityName;
	private String m_trapOid;
	private int m_genericId;
	private int m_specificId;
	private String[] m_varBindValue;

	public SnmpTrapMessageInfo(){
	}

	public SnmpTrapMessageInfo(String monitorId, String facilityId, Date trapDate,
			String communityName, String oid, int genericId, int specificId, String[] bindValue, String agentAdder) {
		m_monitorId = monitorId;
		m_facilityId = facilityId;
		m_trapDate = trapDate;
		m_communityName = communityName;
		m_trapOid = oid;
		m_genericId = genericId;
		m_specificId = specificId;
		m_varBindValue = bindValue;
		m_agentAdder = agentAdder;
	}

	public int getGenericId() {
		return m_genericId;
	}

	public void setGenericId(int genericId) {
		this.m_genericId = genericId;
	}

	public int getSpecificId() {
		return m_specificId;
	}

	public void setSpecificId(int specificId) {
		this.m_specificId = specificId;
	}

	public Date getTrapDate() {
		return m_trapDate;
	}

	public void setTrapDate(Date date) {
		m_trapDate = date;
	}

	public String getCommunityName() {
		return m_communityName;
	}

	public void setCommuinityName(String communityName) {
		m_communityName = communityName;
	}

	public String getTrapOid() {
		return m_trapOid;
	}

	public void setTrapOid(String trapOid) {
		this.m_trapOid = trapOid;
	}

	public String getFacilityId() {
		return m_facilityId;
	}

	public void setFacilityId(String id) {
		m_facilityId = id;
	}

	public String getMonitorId() {
		return m_monitorId;
	}

	public void setMonitorId(String id) {
		m_monitorId = id;
	}

	public String[] getVarBindValue() {
		return m_varBindValue;
	}

	public void setVarBindValue(String[] bindValue) {
		m_varBindValue = bindValue;
	}

	public String getAgentAdder() {
		return m_agentAdder;
	}
}
