/*

Copyright (C) 2008 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.factory;

import java.sql.Timestamp;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 *　OIDマスター情報を変更するクラス<BR>
 *
 * @version 3.0.0
 * @since 2.4.0
 * @author Yosuke
 */
public class ModifyOidMaster {

	protected static Log m_log = LogFactory.getLog( ModifyOidMaster.class );


	protected SnmpTrapMasterInfo m_OidData;

	/**
	 * OIDマスター情報を変更します。
	 * 
	 * @param oidData　変更するマスター情報
	 * @param user　変更実行ユーザ
	 * @return
	 * @throws CreateException
	 * @throws NotSupportedException
	 * @throws RollbackException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws SystemException
	 * @throws InvalidTransactionException
	 * @throws NamingException
	 * @throws MonitorNotFound
	 */
	public boolean modify(SnmpTrapMasterInfo oidData, String user) throws CreateException, NotSupportedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, InvalidTransactionException, NamingException, MonitorNotFound {

		m_OidData = oidData;

		boolean result = false;

		// 監視情報を登録
		result = modifyOIDMaster(user);

		return result;
	}

	/**
	 * OIDマスター情報の変更を行う。
	 * @param user　変更実行ユーザ
	 * 
	 * @return
	 * @throws NamingException
	 * @throws MonitorNotFound
	 * @throws FinderException
	 */
	public boolean modifyOIDMaster(String user) throws NamingException, MonitorNotFound {
		boolean result = false;

		try
		{
			Timestamp now = new Timestamp(new Date().getTime());


			// 監視情報を検索

			SnmpTrapMasterLocal OIDMaster = SnmpTrapMasterUtil.getLocalHome()
			.findByPrimaryKey(new SnmpTrapMasterPK(m_OidData.getMib(),
					m_OidData.getTrapOid(),
					m_OidData.getGenericId(),
					m_OidData.getSpecificId()));

			OIDMaster.setUei(m_OidData.getUei());
			OIDMaster.setPriority(m_OidData.getPriority());
			OIDMaster.setLogmsg(m_OidData.getLogmsg());
			OIDMaster.setDescr(m_OidData.getDescr());

			result = true;

		} catch (NamingException e) {
			outputLog(e, "addOIDMaster()");
			throw e;
		} catch (FinderException e) {
			outputLog(e, "addOIDMaster()" + e.getMessage());
			throw new MonitorNotFound(e.getMessage(), e);
		}
		return result;
	}

	/**
	 * アプリケーションログにログを出力
	 * 
	 * @param e 例外
	 */
	private void outputLog(Exception e, String method){
		AplLogger apllog = new AplLogger("TRAP", "trap");
		String[] args = {m_OidData.getMib(), m_OidData.getTrapOid(),Integer.toString(m_OidData.getGenericId()),
				Integer.toString(m_OidData.getSpecificId())};
		apllog.put("SYS", "001", args);
		m_log.debug(method + ":" + e.getMessage());
	}
}
