/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.factory;

import java.sql.Timestamp;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterData;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 *　MIBマスター情報を変更するクラス<BR>
 *
 * @version 3.0.0
 * @since 2.4.0
 * @author Yosuke
 */
public class ModifyMibMaster {

	protected static Log m_log = LogFactory.getLog( ModifyMibMaster.class );

	/** 監視情報ビーン */
	protected SnmpTrapMibMasterData m_MibData;

	/**
	 * MIBマスター情報を変更します。
	 * 
	 * @param MibData　変更するマスター情報
	 * @param user　変更実行ユーザ
	 * @return
	 * @throws CreateException
	 * @throws NotSupportedException
	 * @throws RollbackException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws SystemException
	 * @throws InvalidTransactionException
	 * @throws NamingException
	 * @throws MonitorNotFound
	 */
	public boolean modify(SnmpTrapMibMasterData mibData, String user) throws CreateException, NotSupportedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, InvalidTransactionException, NamingException, MonitorNotFound {

		m_MibData = mibData;

		boolean result = false;
		// 監視情報を登録
		result = modifyMibMaster(user);

		return result;
	}

	/**
	 * MIBマスター情報の変更を行う。
	 * @param user　変更実行ユーザ
	 * 
	 * @return
	 * @throws NamingException
	 * @throws MonitorNotFound
	 */
	public boolean modifyMibMaster(String user) throws NamingException, MonitorNotFound {
		boolean result = false;

		try
		{
			Timestamp now = new Timestamp(new Date().getTime());


			// 監視情報を検索

			SnmpTrapMibMasterLocal mibMaster =  SnmpTrapMibMasterUtil.getLocalHome()
			.findByPrimaryKey(new SnmpTrapMibMasterPK(m_MibData.getMib()));

			mibMaster.setDescription(m_MibData.getDescription());
			mibMaster.setOrderNo(m_MibData.getOrderNo());
			mibMaster.setUpdateDate(now.getTime());
			mibMaster.setUpdateUser(user);

			result = true;

		} catch (NamingException e) {
			outputLog(e, "addMibMaster()");
			throw e;
		} catch (FinderException e) {
			outputLog(e, "addMibMaster()");
			throw new MonitorNotFound(e.getMessage(), e);
		}
		return result;
	}

	/**
	 * アプリケーションログにログを出力
	 * 
	 * @param e 例外
	 */
	private void outputLog(Exception e, String method){
		AplLogger apllog = new AplLogger("TRAP", "trap");
		String[] args = {m_MibData.getMib()};
		apllog.put("SYS", "001", args);
		m_log.debug(method + ":" + e.getMessage());
	}
}
