/*

Copyright (C) 2008 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.factory;

import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 *OIDマスター情報を登録するクラス<BR>
 *
 * @version 3.0.0
 * @since 2.4.0
 * @author Yosuke
 */
public class AddOidMaster {

	protected static Log m_log = LogFactory.getLog( AddOidMaster.class );

	/** 監視情報ビーン */
	protected SnmpTrapMasterInfo m_OidData;

	/**
	 * OIDマスター情報を登録します。
	 * @param oidData  登録するOIDマスター
	 * @param user     登録実行ユーザ
	 * @return
	 * @throws CreateException
	 * @throws NotSupportedException
	 * @throws RollbackException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws SystemException
	 * @throws InvalidTransactionException
	 * @throws NamingException
	 */
	public boolean add(SnmpTrapMasterInfo oidData, String user) throws CreateException, NotSupportedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, InvalidTransactionException, NamingException {

		m_OidData = oidData;

		boolean result = false;

		// 監視情報を登録
		result = addOIDMaster(user);

		return result;
	}

	/**
	 *  OIDマスター情報を登録します。<BR>
	 * 
	 * @param user ユーザ
	 * @return 登録に成功した場合、true
	 * @throws CreateException
	 * @throws NamingException
	 */
	public boolean addOIDMaster(String user) throws CreateException, NamingException {
		boolean result = false;

		try
		{
			// 監視情報を挿入
			SnmpTrapMasterUtil.getLocalHome().create(
					m_OidData.getMib(),
					m_OidData.getTrapOid(),
					m_OidData.getGenericId(),
					m_OidData.getSpecificId(),
					m_OidData.getUei(),
					m_OidData.getPriority(),
					m_OidData.getLogmsg(),
					m_OidData.getDescr()
			);

			result = true;

		} catch (CreateException e) {
			outputLog(e, "addOIDMaster()");
			throw e;
		} catch (NamingException e) {
			outputLog(e, "addOIDMaster()");
			throw e;
		}
		return result;
	}

	/**
	 * アプリケーションログにログを出力
	 * 
	 * @param e 例外
	 */
	private void outputLog(Exception e, String method){
		AplLogger apllog = new AplLogger("TRAP", "trap");
		String[] args = {m_OidData.getTrapOid(), Integer.toString(m_OidData.getGenericId()), Integer.toString(m_OidData.getSpecificId())};
		apllog.put("SYS", "001", args);
		m_log.debug(method + ":" + e.getMessage());
	}
}
