/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.repository.factory;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.FacilityNotFound;
import com.clustercontrol.repository.bean.ScopeInfo;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.repository.ejb.entity.FacilityUtil;


/**
 * スコープ用プロパティを作成するクラス<BR>
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScopeProperty {

	private static Log m_log = LogFactory.getLog(ScopeProperty.class);

	/**
	 * スコープ用プロパティを返します。
	 * 
	 * @param facilityId
	 * @param mode
	 * @return スコープ用プロパティ
	 * @throws NamingException
	 * @throws FacilityNotFound
	 */
	public static ScopeInfo getProperty(String facilityId) throws NamingException, FacilityNotFound {
		ScopeInfo property = new ScopeInfo();

		if(facilityId != null && facilityId.compareTo("") != 0){

			//Facility取得
			FacilityLocal facility;
			try {
				facility = FacilityUtil.getLocalHome().findByPrimaryKey(facilityId);
			} catch (FinderException e) {
				m_log.warn("getProperty " + e.getMessage(), e);
				throw new FacilityNotFound(e.getMessage(), e);
			}

			if(facility != null){
				//ファシリティID
				property.setFacilityId(facility.getFacilityId());
				//ファシリティ名
				property.setFacilityName(facility.getFacilityName());
				//説明
				if(facility.getDescription() != null && facility.getDescription().compareTo("") != 0){
					property.setDescription(facility.getDescription());
				}

			}
		}

		return property;
	}

}
