/*

Copyright (C) 2009 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.util;

import java.util.Date;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.notify.bean.NotifyRequestMessage;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * ファイル出力クラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class OutputFile implements Notifier {
	/**
	 * ファイル出力処理
	 * 
	 * @param info
	 * @return
	 */
	@Override
	public void notify(NotifyRequestMessage message) throws Exception {
		AplLogger apllog = new AplLogger(message.getOutputInfo().getPluginId(), message.getOutputInfo().getApplication());
		apllog.putFile(
				new Date(),
				message.getOutputInfo().getMonitorId(),
				message.getOutputInfo().getMessageId(),
				PriorityConstant.typeToString(message.getOutputInfo().getPriority()),
				message.getOutputInfo().getMessage(),
				message.getOutputInfo().getMessageOrg());
	}

	/**
	 * 通知失敗時の内部エラー通知を定義します
	 */
	@Override
	public void internalErrorNotify(String notifyId, String msgID, String detailMsg) throws Exception {
		//FIXME
		// 何もしない
	}
}
