/*

Copyright (C) since 2009 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

 */

package com.clustercontrol.performance.factory;

import java.util.Collection;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import com.clustercontrol.performance.monitor.ejb.entity.CollectorPollingMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorPollingMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorPollingMstPK;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorPollingMstUtil;

/**
 * 収集方法・プラットフォーム毎の収集項目マスタ情報追加クラス
 * 
 * @version 1.2.0
 * @since 1.2.0
 * @author uchiyama
 *
 */
public class OperateCollectPollingMaster {

	/**
	 * 収集方法・プラットフォーム毎の収集項目マスタ情報を追加します。
	 * 
	 * @param data 収集方法・プラットフォーム毎の収集項目情報
	 * @return 成功した場合、true
	 * @throws NamingException
	 * @throws CreateException
	 * 
	 */
	public boolean add(CollectorPollingMstData data) throws CreateException, NamingException {

		// 収集方法毎の収集項目情報の追加
		CollectorPollingMstUtil.getLocalHome().create(
				data.getCollectMethod(),
				data.getPlatformId(),
				data.getSubPlatformId(),
				data.getItemCode(),
				data.getVariableId(),
				data.getEntryKey(),
				data.getValueType(),
				data.getPollingTarget(),
				data.getFailureValue()
		);

		return true;
	}

	/**
	 * 収集方法・プラットフォーム毎の収集項目マスタ情報を削除します。
	 * @throws NamingException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws EJBException
	 */
	public boolean delete(CollectorPollingMstPK pk) throws FinderException, NamingException, EJBException, RemoveException {

		CollectorPollingMstLocal local = CollectorPollingMstUtil.getLocalHome().findByPrimaryKey(pk);
		// pkが同じデータが登録されている場合は、削除する
		local.remove();

		return true;
	}

	/**
	 * 収集方法・プラットフォーム毎の収集項目マスタ情報を全て削除します。
	 * @throws NamingException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws EJBException
	 */
	public boolean deleteAll() throws FinderException, NamingException, EJBException, RemoveException {

		Collection<CollectorPollingMstLocal> col = CollectorPollingMstUtil.getLocalHome().findAll();
		Iterator<CollectorPollingMstLocal> itr = col.iterator();

		while(itr.hasNext()){
			itr.next().remove();
		}

		return true;
	}

}
