/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.performance.dialog.ExportDialog;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.view.PerformanceListView;

/**
 * 収集済みデータのエクスポートを行うアクションクラス
 * 
 * @version 4.0.0
 * @since 1.0.0
 */
public class ExportCollectedDataAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.performance.view.action.ExportCollectedDataAction";

	private static ExportDialog exportDialog;

	private IViewPart viewPart; // ビュー

	/**
	 * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
	 * 
	 * @param view
	 *            ビューのインスタンス
	 * 
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	@Override
	public void init(IViewPart view) {
		this.viewPart = view;
	}

	/**
	 * 性能[一覧]ビューで選択されている性能値をエクスポートします。
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	@Override
	public void run(IAction action) {
		/*
		 * 呼び出し元のViewを持ってきます。
		 */
		IWorkbenchPage page = PlatformUI.getWorkbench()
		.getActiveWorkbenchWindow().getActivePage();
		PerformanceListView listView = (PerformanceListView) page
		.findView(PerformanceListView.ID);

		/*
		 * テーブルで選ばれている監視のIDを取得します。
		 */
		String monitorId = listView.getSelectedMonitorId();
		String monitorTypeId = listView.getSelectedMonitorTypeId();

		if (monitorId != null) {

			// マネージャからプロパティ情報を収集する
			exportDialog = new ExportDialog(this.viewPart.getSite().getShell(), monitorId, monitorTypeId);
			exportDialog.open();

		} else {

			String msg = Messages.getString("MESSAGE_0014");
			MessageDialog.openError(null, Messages.getString("ERROR_IN_JP"),
					msg);
		}
	}

	/**
	 * 
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
	}
}