/*

Copyright (C) 2008 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.mail.action;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.notify.mail.util.MailTemplateEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.mailtemplate.InvalidRole_Exception;
import com.clustercontrol.ws.mailtemplate.MailTemplateInfo;

/**
 * メールテンプレート情報を取得するクライアント側アクションクラス<BR>
 * 
 * @version 2.4.0
 * @since 2.4.0
 */
public class GetMailTemplate {

	// ログ
	private static Log m_log = LogFactory.getLog( GetMailTemplate.class );

	/**
	 * メールテンプレート情報一覧を返します。<BR>
	 * マネージャにSessionBean経由でアクセスします。
	 * 
	 * @return メールテンプレート情報一覧
	 * 
	 */
	public List<MailTemplateInfo> getMailTemplateList() {

		List<MailTemplateInfo> records = null;
		try {
			records = MailTemplateEndpointWrapper.getMailTemplateList();
		} catch (InvalidRole_Exception e) {
			MessageDialog.openInformation(null, Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));
		} catch (Exception e) {
			m_log.warn("getMailTemplateList(), " + e.getMessage(), e);
			MessageDialog.openError(
					null,
					Messages.getString("failed"),
					Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
		}

		return records;
	}
}