/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.view.action;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.jobmanagement.view.JobListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;

/**
 * ジョブコピーするクライアント側アクションクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class CopyJobAction extends Action {
	/** ビュー */
	protected IViewPart m_view;

	/**
	 * コンストラクタ
	 * 
	 * @param view ビュー
	 */
	public CopyJobAction(IViewPart view) {
		m_view = view;

		setText(Messages.getString("copy"));
		setToolTipText(Messages.getString("copy"));
	}

	/**
	 * ジョブ[一覧]ビューにて選択されたジョブツリーアイテムを取得し、<BR>
	 * ジョブ[一覧]ビューにコピー元のジョブツリーアイテムとして設定します。
	 * 
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	@Override
	public void run() {
		JobListView view = (JobListView)m_view.getAdapter(JobListView.class);
		JobTreeItem copyItem = view.getSelectJobTreeItem();
		view.setCopyJobTreeItem(copyItem);
	}
}
