/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.jobmanagement.composite.ScheduleListComposite;
import com.clustercontrol.jobmanagement.view.action.CreateScheduleAction;
import com.clustercontrol.jobmanagement.view.action.DeleteScheduleAction;
import com.clustercontrol.jobmanagement.view.action.DisableScheduleAction;
import com.clustercontrol.jobmanagement.view.action.EnableScheduleAction;
import com.clustercontrol.jobmanagement.view.action.ModifyScheduleAction;
import com.clustercontrol.view.CommonViewPart;

/**
 * ジョブ[スケジュール]ビュークラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScheduleListView extends CommonViewPart {
	/** ビューID */
	public static final String ID = "com.clustercontrol.jobmanagement.view.ScheduleListView";
	/** ジョブ[スケジュール]ビュー用のコンポジット */
	private ScheduleListComposite m_scheduleList = null;

	/**
	 * コンストラクタ
	 */
	public ScheduleListView() {
		super();
	}

	/**
	 * ビューを構築します。
	 * 
	 * @param parent 親コンポジット
	 * 
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 * @see #createContextMenu()
	 * @see #update()
	 */
	@Override
	public void createPartControl(Composite parent) {
		GridLayout layout = new GridLayout(1, true);
		parent.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;

		m_scheduleList = new ScheduleListComposite(parent, SWT.NONE);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		m_scheduleList.setLayoutData(gridData);

		//ポップアップメニュー作成
		createContextMenu();

		//ビューの更新
		this.update();
	}

	/**
	 * コンテキストメニューを作成します。
	 * 
	 * @see org.eclipse.jface.action.MenuManager
	 * @see org.eclipse.swt.widgets.Menu
	 */
	protected void createContextMenu() {
		MenuManager menuManager = new MenuManager();
		menuManager.setRemoveAllWhenShown(true);
		menuManager.addMenuListener(new IMenuListener() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
			 */
			@Override
			public void menuAboutToShow(IMenuManager manager) {
				//メニュー項目設定
				fillContextMenu(manager);
			}
		});

		Menu menu = menuManager.createContextMenu(m_scheduleList.getTable());
		m_scheduleList.getTable().setMenu(menu);
	}

	/**
	 * コンテキストメニューに項目を追加します。
	 * 
	 * @param manager メニューマネージャ
	 * 
	 * @see org.eclipse.jface.action.IToolBarManager
	 * @see org.eclipse.jface.action.IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		//ビューのアクションのインスタンスを取得
		IToolBarManager toolbar = this.getViewSite().getActionBars()
		.getToolBarManager();
		ActionContributionItem createScheduleAction = (ActionContributionItem) toolbar
		.find(CreateScheduleAction.ID);
		ActionContributionItem modifyScheduleAction = (ActionContributionItem) toolbar
		.find(ModifyScheduleAction.ID);
		ActionContributionItem deleteScheduleAction = (ActionContributionItem) toolbar
		.find(DeleteScheduleAction.ID);

		//ポップアップメニューにアクションを追加
		manager.add(createScheduleAction.getAction());
		manager.add(modifyScheduleAction.getAction());
		manager.add(deleteScheduleAction.getAction());
	}

	/**
	 * ビューを更新します。
	 * 
	 * @see com.clustercontrol.jobmanagement.composite.ScheduleListComposite#update()
	 */
	public void update() {
		m_scheduleList.update();
	}

	/**
	 * ジョブ[スケジュール]ビュー用のコンポジットを返します。
	 * 
	 * @return ジョブ[スケジュール]ビュー用のコンポジット
	 */
	public ScheduleListComposite getComposite() {
		return m_scheduleList;
	}

	/**
	 * ビューのアクションの有効/無効を設定します。
	 * 
	 * @param num 選択イベント数
	 * @param selection ボタン（アクション）を有効にするための情報
	 */
	public void setEnabledAction(int num, ISelection selection) {
		//ビューアクションの使用可/不可を設定
		super.setEnabledAction(ModifyScheduleAction.ID, selection);
		super.setEnabledAction(DeleteScheduleAction.ID, selection);
		super.setEnabledAction(EnableScheduleAction.ID, selection);
		super.setEnabledAction(DisableScheduleAction.ID, selection);

		if (num > 0){
			super.setEnabledAction(EnableScheduleAction.ID, true);
			super.setEnabledAction(DisableScheduleAction.ID, true);

			if(num == 1){
				super.setEnabledAction(ModifyScheduleAction.ID, true);
				super.setEnabledAction(DeleteScheduleAction.ID, true);
			}else{
				super.setEnabledAction(ModifyScheduleAction.ID, false);
				super.setEnabledAction(DeleteScheduleAction.ID, false);
			}

		} else {
			super.setEnabledAction(EnableScheduleAction.ID, false);
			super.setEnabledAction(DisableScheduleAction.ID, false);
			super.setEnabledAction(ModifyScheduleAction.ID, false);
			super.setEnabledAction(DeleteScheduleAction.ID, false);
		}
	}
}