/*

Copyright (C) 2010 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.action;

import java.util.ArrayList;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.util.Messages;

/**
 * 管理ユーザダイアログのテーブル定義を取得するクライアント側アクションクラス<BR>
 * @author Hinemos
 *
 */
public class GetUserTableDefine {

	/** チェックボックス。 */
	public static final int SELECTION = 0;

	/** ユーザID。 */
	public static final int USER_ID = 1;

	/** ユーザ名。 */
	public static final int USER_NAME = 2;

	/** 説明。 */
	public static final int DESCRIPTION = 3;


	/** 初期表示時ソートカラム。 */
	public static final int SORT_COLUMN_INDEX = USER_ID;

	/** 初期表示時ソートオーダー。 */
	public static final int SORT_ORDER = 1;

	/**
	 * 
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static ArrayList get() {
		/** テーブル情報定義配列 */
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(SELECTION,
				new TableColumnInfo("", TableColumnInfo.CHECKBOX, 30, SWT.LEFT));
		tableDefine.add(USER_ID,
				new TableColumnInfo(Messages.getString("user.id"), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(USER_NAME,
				new TableColumnInfo(Messages.getString("user.name"), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(DESCRIPTION,
				new TableColumnInfo(Messages.getString("description"), TableColumnInfo.NONE, 130, SWT.LEFT));
		return tableDefine;
	}
}
