/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.dialog;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.collectiverun.composite.TreeComposite;
import com.clustercontrol.collectiverun.composite.action.TreeSelectionChangedListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.util.Messages;

/**
 * 設定ダイアログクラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 * 
 */
public class SetMasterDialog extends CommonDialog {
	protected SashForm sash = null;
	protected TreeComposite treeComposite = null;
	protected Composite detailComposite = null;

	/**
	 * コンストラクタ
	 * 
	 * @param parent
	 */
	public SetMasterDialog(Shell parent) {
		super(parent);
		setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
	}

	/**
	 * ダイアログのサイズを指定
	 * 
	 * @see org.eclipse.jface.window.Window#getInitialSize()
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(700, 500);
	}

	/**
	 * ダイアログのカスタマイズ
	 * 
	 * @param parent
	 *            ダイアログエリアのコンポジットオブジェクト
	 */
	@Override
	protected void customizeDialog(Composite parent) {
		Shell shell = this.getShell();

		shell.setText(
				Messages.getString("dialog.collective.run.create.change"));

		GridLayout layout = new GridLayout(1, true);
		parent.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;

		sash = new SashForm(parent, SWT.HORIZONTAL);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		sash.setLayoutData(gridData);

		//ジョブ階層ツリー作成
		treeComposite = new TreeComposite(sash, SWT.NONE);

		//ジョブ一覧作成
		detailComposite = new Composite(sash, SWT.NONE);

		//Sashの境界を調整 左部40% 右部60%
		sash.setWeights(new int[] { 40, 60 });

		// 選択アイテム取得イベント定義
		treeComposite.getTreeViewer().addSelectionChangedListener(
				new TreeSelectionChangedListener(this));

		//ポップアップメニュー作成
		//        createContextMenu();

		// ラインを引く
		Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalSpan = 1;
		line.setLayoutData(gridData);

		//ビューを更新
		this.update();

		//ツリーを開く
		treeComposite.getTreeViewer().expandToLevel(2);
	}

	/**
	 * ビューを更新します。
	 * 
	 */
	public void update() {
		treeComposite.update();
	}

	/**
	 * 閉じるボタンを作成します。
	 * 
	 * @param parent ボタンバーコンポジット
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {

		// 閉じるボタン
		this.createButton(parent, IDialogConstants.CANCEL_ID, Messages.getString("close"), false);
	}

	/**
	 * @return
	 */
	public Composite getParentComposite() {
		return this.sash;
	}

	/**
	 * @return
	 */
	public Composite getDetail() {
		return detailComposite;
	}

	/**
	 * @param detailComposite
	 */
	public void setDetail(Composite detail) {
		int[] weights = this.sash.getWeights();

		this.detailComposite.dispose();
		this.detailComposite = detail;

		this.sash.setWeights(new int[] { weights[0], weights[1] });
	}

	/**
	 * @return
	 */
	public TreeComposite getTree() {
		return treeComposite;
	}

	/**
	 * @param tree
	 */
	public void setTree(TreeComposite tree) {
		this.treeComposite = tree;
	}
}