/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.dialog;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.bean.Property;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.util.Messages;

/**
 * インストール管理ダイアログクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 * 
 */
public class RunConfirmedDialog extends CommonDialog {

	/** ノード属性プロパティシート */
	private PropertySheet m_propertySheet = null;

	private String m_type = null;

	private Property m_date = null;

	/**
	 * コンストラクタ
	 * 
	 * @param parent
	 */
	public RunConfirmedDialog(Shell parent) {
		super(parent);
	}

	/**
	 * ダイアログのサイズを指定
	 * 
	 * @see org.eclipse.jface.window.Window#getInitialSize()
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(450, 450);
	}

	/**
	 * ダイアログのカスタマイズ
	 * 
	 * @param parent
	 *            ダイアログエリアのコンポジットオブジェクト
	 */
	@Override
	protected void customizeDialog(Composite parent) {

		//レイアウト
		GridLayout layout = new GridLayout(1, true);
		layout.marginWidth = 10;
		layout.marginHeight = 10;
		parent.setLayout(layout);

		//タイトル
		Shell shell = this.getShell();
		shell.setText(Messages.getString("confirmed"));

		//種別
		Label management = new Label(parent, SWT.LEFT);
		management.setText(Messages.getString("type") + " : "
				+ m_type);

		TableTree table = new TableTree(parent, SWT.H_SCROLL | SWT.V_SCROLL
				| SWT.FULL_SELECTION | SWT.MULTI | SWT.BORDER);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		gridData.horizontalSpan = 1;
		table.setLayoutData(gridData);

		this.m_propertySheet = new PropertySheet(table);
		this.m_propertySheet.setInput(m_date);

		this.m_propertySheet.expandAll();
	}

	/**
	 * ＯＫボタンのテキストを返します。
	 * 
	 * @return ＯＫボタンのテキスト
	 */
	@Override
	protected String getOkButtonText() {
		return Messages.getString("run");
	}

	/**
	 * @return Returns the date.
	 */
	public Property getDate() {
		return m_date;
	}

	/**
	 * @param date
	 *            The date to set.
	 */
	public void setDate(Property date) {
		m_date = date;
	}

	/**
	 * @return Returns the type.
	 */
	public String getType() {
		return m_type;
	}

	/**
	 * @param type
	 *            The type to set.
	 */
	public void setType(String type) {
		m_type = type;
	}
}