/*

Copyright (C) since 2009 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */
package com.clustercontrol.calendar.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.calendar.bean.AddConstant;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.ws.calendar.CalendarAddInfo;

/**
 * カレンダ追加情報のDTOとプロパティを相互変換するためのユーティリティクラスです。
 * @since 0.1
 */
public class CalendarAddPropertyUtil {

	/**
	 * プロパティをカレンダ追加情報に変換するメソッドです。
	 * 
	 * @param property
	 * @return カレンダ追加情報
	 */
	public static CalendarAddInfo property2dto(Property property){
		CalendarAddInfo info = new CalendarAddInfo();
		info.setExecuteFlag(false);
		info.setTimeFrom(0L);
		info.setTimeTo(0L);
		info.setRegDate(0L);
		info.setUpdateDate(0L);

		ArrayList object = null;

		//時間帯(From)
		object = PropertyUtil.getPropertyValue(property, AddConstant.TIME_FROM);
		if (object.size() > 0 && object.get(0) != null && !object.get(0).toString().equals("")) {
			info.setTimeFrom(((Date) (object.get(0))).getTime());
		}
		//時間帯(To)
		object = PropertyUtil.getPropertyValue(property, AddConstant.TIME_TO);
		if (object.size() > 0 && object.get(0) != null && !object.get(0).toString().equals("")) {
			info.setTimeTo(((Date) (object.get(0))).getTime());
		}
		//実行
		object = PropertyUtil.getPropertyValue(property, AddConstant.EXECUTE);
		if (object.size() > 0) {
			info.setExecuteFlag((Boolean)object.get(0));
		}
		//説明
		object = PropertyUtil.getPropertyValue(property, AddConstant.DESCRIPTION);
		if (object.size() > 0) {
			info.setDescription((String)object.get(0));
		}
		//登録者
		object = PropertyUtil.getPropertyValue(property, AddConstant.CREATOR_NAME);
		if (object.size() > 0) {
			info.setRegUser((String)object.get(0));
		}
		//登録日時
		object = PropertyUtil.getPropertyValue(property, AddConstant.CREATE_TIME);
		if (object.size() > 0 && object.get(0) != null && !object.get(0).toString().equals("")) {
			info.setRegDate(((Date) (object.get(0))).getTime());
		}
		//更新者
		object = PropertyUtil.getPropertyValue(property, AddConstant.MODIFIER_NAME);
		if (object.size() > 0) {
			info.setUpdateUser((String)object.get(0));
		}
		//更新日時
		object = PropertyUtil.getPropertyValue(property, AddConstant.MODIFY_TIME);
		if (object.size() > 0 && object.get(0) != null && !object.get(0).toString().equals("")) {
			info.setUpdateDate(((Date) (object.get(0))).getTime());
		}


		return info;
	}

	/**
	 * カレンダ追加情報DTOをプロパティに変換するメソッドです。
	 * 
	 * @param info
	 * @param mode
	 * @param locale
	 * @return プロパティ
	 */
	public static Property dto2property(CalendarAddInfo info, int mode, Locale locale){
		/** ローカル変数 */
		Property property = null;
		ArrayList propertyList = null;

		/** メイン処理 */
		property = getProperty(mode, locale);

		if(info != null){
			//時間帯(From)
			propertyList = PropertyUtil.getProperty(property, AddConstant.TIME_FROM);
			if(info.getTimeFrom() != null){
				((Property)propertyList.get(0)).setValue(new Date(info.getTimeFrom()));
			}
			//時間帯(To)
			propertyList = PropertyUtil.getProperty(property, AddConstant.TIME_TO);
			if(info.getTimeTo() != null){
				((Property)propertyList.get(0)).setValue(new Date(info.getTimeTo()));
			}
			//実行
			propertyList = PropertyUtil.getProperty(property, AddConstant.EXECUTE);
			((Property)propertyList.get(0)).setValue(info.isExecuteFlag());

			//説明
			propertyList = PropertyUtil.getProperty(property, AddConstant.DESCRIPTION);
			if(info.getDescription() != null && info.getDescription().compareTo("") != 0){
				((Property)propertyList.get(0)).setValue(info.getDescription());
			}
			//登録者
			propertyList = PropertyUtil.getProperty(property, AddConstant.CREATOR_NAME);
			if(info.getRegUser() != null && info.getRegUser().compareTo("") != 0){
				((Property)propertyList.get(0)).setValue(info.getRegUser());
			}
			//登録日時
			propertyList = PropertyUtil.getProperty(property, AddConstant.CREATE_TIME);
			if(info.getRegDate() != null){
				((Property)propertyList.get(0)).setValue(new Date(info.getRegDate()));
			}
			//更新者
			propertyList = PropertyUtil.getProperty(property, AddConstant.MODIFIER_NAME);
			if(info.getUpdateUser() != null && info.getUpdateUser().compareTo("") != 0){
				((Property)propertyList.get(0)).setValue(info.getUpdateUser());
			}
			//更新日時
			propertyList = PropertyUtil.getProperty(property, AddConstant.MODIFY_TIME);
			if(info.getUpdateDate() != null){
				((Property)propertyList.get(0)).setValue(new Date(info.getUpdateDate()));
			}
		}

		return property;
	}


	/**
	 * カレンダ追加情報用プロパティを取得します。<BR>
	 * 
	 * @param mode
	 * @param locale
	 * @return カレンダ追加情報用プロパティ
	 */
	private static Property getProperty(int mode, Locale locale) {
		//時間帯(From)
		Property timeFrom =
			new Property(AddConstant.TIME_FROM, Messages.getString("time", locale) + "(" + Messages.getString("start", locale) + ")",
					PropertyConstant.EDITOR_DATETIME);
		//時間帯(To)
		Property timeTo =
			new Property(AddConstant.TIME_TO, Messages.getString("time", locale) + "(" + Messages.getString("end", locale) + ")"
					, PropertyConstant.EDITOR_DATETIME);
		//実行
		Property execute =
			new Property(AddConstant.EXECUTE, Messages.getString("run", locale), PropertyConstant.EDITOR_BOOL);
		//説明
		Property description =
			new Property(AddConstant.DESCRIPTION, Messages.getString("description", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_256);
		//登録日時
		Property createTime =
			new Property(AddConstant.CREATE_TIME, Messages.getString("create.time", locale), PropertyConstant.EDITOR_DATETIME);
		//登録者
		Property creatorName =
			new Property(AddConstant.CREATOR_NAME, Messages.getString("creator.name", locale), PropertyConstant.EDITOR_TEXT);
		//更新日時
		Property modifyTime =
			new Property(AddConstant.MODIFY_TIME, Messages.getString("update.time", locale), PropertyConstant.EDITOR_DATETIME);
		//更新者
		Property modifierName =
			new Property(AddConstant.MODIFIER_NAME, Messages.getString("modifier.name", locale), PropertyConstant.EDITOR_TEXT);

		//値を初期化
		timeFrom.setValue("");
		timeTo.setValue("");
		execute.setValue(Boolean.valueOf(true));
		description.setValue("");
		createTime.setValue("");
		creatorName.setValue("");
		modifyTime.setValue("");
		modifierName.setValue("");

		//モードにより、変更可及びコピー可を設定
		if(mode == PropertyConstant.MODE_ADD){
			execute.setModify(PropertyConstant.MODIFY_OK);
			timeFrom.setModify(PropertyConstant.MODIFY_OK);
			timeTo.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
		}
		else if(mode == PropertyConstant.MODE_MODIFY){
			execute.setModify(PropertyConstant.MODIFY_OK);
			timeFrom.setModify(PropertyConstant.MODIFY_OK);
			timeTo.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
		}

		Property property = new Property(null, null, "");

		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(timeFrom);
		property.addChildren(timeTo);
		property.addChildren(execute);
		property.addChildren(description);
		property.addChildren(createTime);
		property.addChildren(creatorName);
		property.addChildren(modifyTime);
		property.addChildren(modifierName);

		return property;
	}
}
