/*

Copyright (C) 2009 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */
package com.clustercontrol.accesscontrol.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.bean.RoleConstant;
import com.clustercontrol.accesscontrol.bean.UserConstant;
import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.ws.access.UserFilterInfo;

/**
 * ユーザ情報検索条件のDTOとプロパティを相互変換するためのユーティリティクラスです。
 * 
 * @version 4.0.0
 */
public class UserFilterPropertyUtil {
	/** ログ出力のインスタンス */
	private static Log m_log = LogFactory.getLog(UserFilterPropertyUtil.class);

	/** ユーザID */
	public static final String UID = "uid";
	/** 名前 */
	public static final String NAME = "namae";
	/** 説明 */
	public static final String DESCRIPTION = "description";

	/** アクセス権限 */
	public static final String ACCESS = "access";

	public static UserFilterInfo property2dto(Property property){
		UserFilterInfo info = new UserFilterInfo();
		ArrayList object = null;

		//ユーザID
		object = PropertyUtil.getPropertyValue(property, UserConstant.UID);
		if (object.size() > 0) {
			info.setUserId((String)object.get(0));
		}
		//ユーザ名
		object = PropertyUtil.getPropertyValue(property, UserConstant.NAME);
		if (object.size() > 0) {
			info.setUserName((String)object.get(0));
		}
		//説明
		object = PropertyUtil.getPropertyValue(property, UserConstant.DESCRIPTION);
		if (object.size() > 0) {
			info.setDescription((String)object.get(0));
		}

		//Role
		object = PropertyUtil.getProperty(property, UserConstant.ACCESS);
		if (object.size() > 0) {
			Property accessProperty = (Property)object.get(0);
			for(String role : UserPropertyUtil.getRoleList().getRoles()){
				ArrayList roleProperties = PropertyUtil.getProperty(accessProperty, role);
				if(roleProperties.size() > 0 && (Boolean)((Property)roleProperties.get(0)).getValue()){
					List<String> roleList = info.getRoleList();
					roleList.add(role);
				}
			}
		}


		return info;
	}

	public static Property dto2property(UserFilterInfo info, Locale locale){
		Property property = getProperty(locale);
		ArrayList propertyList = null;

		if(info != null){
			//ユーザID
			propertyList = PropertyUtil.getProperty(property, UserConstant.UID);
			((Property)propertyList.get(0)).setValue(info.getUserId());
			//ユーザ名
			propertyList = PropertyUtil.getProperty(property, UserConstant.NAME);
			if(info.getUserName() != null && info.getUserName().compareTo("") != 0){
				((Property)propertyList.get(0)).setValue(info.getUserName());
			}
			//説明
			propertyList = PropertyUtil.getProperty(property, UserConstant.DESCRIPTION);
			if(info.getDescription() != null && info.getDescription().compareTo("") != 0){
				((Property)propertyList.get(0)).setValue(info.getDescription());
			}
			//アクセス権限
			propertyList = PropertyUtil.getProperty(property, UserConstant.ACCESS);
			Property accessProperty = (Property)propertyList.get(0);

			//Role
			for (String role : info.getRoleList()) {
				propertyList = PropertyUtil.getProperty(accessProperty, role);
				if(propertyList.size() > 0) {
					((Property)propertyList.get(0)).setValue(Boolean.valueOf(true));
				}
			}
		}
		return property;
	}

	/**
	 * ユーザフィルタ用プロパティを返す。<BR>
	 * <p>
	 * <ol>
	 * <li>フィルタ項目毎にID, 名前, 処理定数（{@link com.clustercontrol.bean.PropertyConstant}）を指定し、
	 * プロパティ（{@link com.clustercontrol.bean.Property}）を生成する。</li>
	 * <li>各フィルタ項目のプロパティをツリー状に定義する。</li>
	 * </ol>
	 * 
	 * <p>
	 * プロパティに定義するフィルタ条件は、下記の通り。
	 * <p>
	 * <ul>
	 * <li>プロパティ（親。ダミー）</li>
	 * <ul>
	 * <li>ユーザID（子。テキスト）</li>
	 * <li>名前（子。テキスト）</li>
	 * <li>説明（子。テキスト）</li>
	 * <li>アクセス権（子。テキスト）</li>
	 * <ul>
	 * <li>リポジトリ - 参照（孫。チェックボックス）</li>
	 * <li>リポジトリ - 設定（孫。チェックボックス）</li>
	 * <li>アクセス - 参照（孫。チェックボックス）</li>
	 * <li>アクセス - 設定（孫。チェックボックス）</li>
	 * <li>監視管理 - 参照（孫。チェックボックス）</li>
	 * <li>監視管理 - 設定（孫。チェックボックス）</li>
	 * <li>ジョブ管理 - 参照（孫。チェックボックス）</li>
	 * <li>ジョブ管理 - 設定（孫。チェックボックス）</li>
	 * <li>ジョブ管理 - 実行（孫。チェックボックス）</li>
	 * <li>性能管理 - 参照（孫。チェックボックス）</li>
	 * <li>性能管理 - 設定（孫。チェックボックス）</li>
	 * <li>性能管理 - 実行（孫。チェックボックス）</li>
	 * <li>一括制御 - 参照（孫。チェックボックス）</li>
	 * <li>一括制御 - 設定（孫。チェックボックス）</li>
	 * <li>一括制御 - 実行（孫。チェックボックス）</li>
	 * <li>システムログ監視 - 参照（孫。チェックボックス）</li>
	 * <li>システムログ監視 - 設定（孫。チェックボックス）</li>
	 * <li>PING監視 - 参照（孫。チェックボックス）</li>
	 * <li>PING監視 - 設定（孫。チェックボックス）</li>
	 * <li>サービス・ポート監視 - 参照（孫。チェックボックス）</li>
	 * <li>サービス・ポート監視 - 設定（孫。チェックボックス）</li>
	 * <li>プロセス監視 - 参照（孫。チェックボックス）</li>
	 * <li>プロセス監視 - 設定（孫。チェックボックス）</li>
	 * <li>SNMP監視 - 参照（孫。チェックボックス）</li>
	 * <li>SNMP監視 - 設定（孫。チェックボックス）</li>
	 * <li>SNMPTRAP監視 - 参照（孫。チェックボックス）</li>
	 * <li>SNMPTRAP監視 - 設定（孫。チェックボックス）</li>
	 * <li>SQL監視 - 参照（孫。チェックボックス）</li>
	 * <li>SQL監視 - 設定（孫。チェックボックス）</li>
	 * <li>Hinemosエージェント監視 - 参照（孫。チェックボックス）</li>
	 * <li>Hinemosエージェント監視 - 設定（孫。チェックボックス）</li>
	 * <li>HTTP監視 - 参照（孫。チェックボックス）</li>
	 * <li>HTTP監視 - 設定（孫。チェックボックス）</li>
	 * <li>ログ転送 - 参照（孫。チェックボックス）</li>
	 * <li>ログ転送 - 設定（孫。チェックボックス）</li>
	 * <li>カレンダ - 参照（孫。チェックボックス）</li>
	 * <li>カレンダ - 設定（孫。チェックボックス）</li>
	 * <li>通知 - 参照（孫。チェックボックス）</li>
	 * <li>通知 - 設定（孫。チェックボックス）</li>
	 * <li>重要度判定 - 参照（孫。チェックボックス）</li>
	 * <li>重要度判定 - 設定（孫。チェックボックス）</li>
	 * <li>仮想化管理 - 参照（孫。チェックボックス）</li>
	 * <li>仮想化管理 - 設定（孫。チェックボックス）</li>
	 * <li>仮想化管理 - 実行（孫。チェックボックス）</li>
	 * <li>障害検知 - 参照（孫。チェックボックス）</li>
	 * <li>障害検知 - 設定（孫。チェックボックス）</li>
	 * </ul>
	 * </ul>
	 * </ul>
	 * 
	 * @param locale
	 *            ロケール情報
	 * @return ユーザフィルタ用プロパティ
	 * 
	 * @see com.clustercontrol.bean.Property
	 * @see com.clustercontrol.bean.PropertyConstant
	 */
	public static Property getProperty(Locale locale) {

		/** メイン処理 */
		m_log.debug("getting properties of user's filter...");

		// UID
		Property uid = new Property(UID, Messages.getString("user.id", locale),
				PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		// 名前
		Property name = new Property(NAME, Messages.getString("name", locale),
				PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		// 説明
		Property description = new Property(DESCRIPTION, Messages.getString(
				"description", locale), PropertyConstant.EDITOR_TEXT,
				DataRangeConstant.VARCHAR_1024);

		// アクセス権限
		Property access = new Property(ACCESS, Messages.getString(
				"access.permission", locale), PropertyConstant.EDITOR_TEXT);
		// リポジトリ参照
		Property repositoryRead = new Property(RoleConstant.REPOSITORY_READ, Messages
				.getString("repository.read", locale),
				PropertyConstant.EDITOR_BOOL);
		// リポジトリ設定
		Property repositoryWrite = new Property(RoleConstant.REPOSITORY_WRITE, Messages
				.getString("repository.write", locale),
				PropertyConstant.EDITOR_BOOL);
		// リポジトリ実行
		Property repositoryExecute = new Property(RoleConstant.REPOSITORY_EXECUTE, Messages
				.getString("repository.execute", locale),
				PropertyConstant.EDITOR_BOOL);
		// ユーザ管理参照
		Property accessRead = new Property(RoleConstant.ACCESSCONTROL_READ, Messages
				.getString("accesscontrol.read", locale),
				PropertyConstant.EDITOR_BOOL);
		// ユーザ管理設定
		Property accessWrite = new Property(RoleConstant.ACCESSCONTROL_WRITE, Messages
				.getString("accesscontrol.write", locale),
				PropertyConstant.EDITOR_BOOL);
		// 監視結果参照
		Property monitorResultRead = new Property(RoleConstant.MONITOR_RESULT_READ, Messages.getString(
				"monitor.result.read", locale), PropertyConstant.EDITOR_BOOL);
		// 監視結果設定
		Property monitorResultWrite = new Property(RoleConstant.MONITOR_RESULT_WRITE, Messages.getString(
				"monitor.result.write", locale), PropertyConstant.EDITOR_BOOL);
		// 監視設定参照
		Property monitorSettingRead = new Property(RoleConstant.MONITOR_SETTING_READ, Messages.getString(
				"monitor.setting.read", locale), PropertyConstant.EDITOR_BOOL);
		// 監視設定設定
		Property monitorSettingWrite = new Property(RoleConstant.MONITOR_SETTING_WRITE, Messages.getString(
				"monitor.setting.write", locale), PropertyConstant.EDITOR_BOOL);
		// ジョブ管理参照
		Property jobManagementRead = new Property(RoleConstant.JOBMANAGEMENT_READ, Messages
				.getString("jobmanagement.read", locale),
				PropertyConstant.EDITOR_BOOL);
		// ジョブ設定
		Property jobManagementWrite = new Property(RoleConstant.JOBMANAGEMENT_WRITE,
				Messages.getString("jobmanagement.write", locale),
				PropertyConstant.EDITOR_BOOL);
		// ジョブ実行
		Property jobManagementExecute = new Property(RoleConstant.JOBMANAGEMENT_EXECUTE,
				Messages.getString("jobmanagement.execute", locale),
				PropertyConstant.EDITOR_BOOL);
		// 性能管理参照
		Property performanceRead = new Property(RoleConstant.PERFORMANCE_READ, Messages
				.getString("performance.read", locale),
				PropertyConstant.EDITOR_BOOL);
		// 性能管理実行
		Property performanceExecute = new Property(RoleConstant.PERFORMANCE_EXECUTE,
				Messages.getString("performance.execute", locale),
				PropertyConstant.EDITOR_BOOL);
		// 一括制御参照
		Property collectiverunRead = new Property(RoleConstant.COLLECTIVERUN_READ, Messages
				.getString("collectiverun.read", locale),
				PropertyConstant.EDITOR_BOOL);
		// 一括制御設定
		Property collectiverunWrite = new Property(RoleConstant.COLLECTIVERUN_WRITE,
				Messages.getString("collectiverun.write", locale),
				PropertyConstant.EDITOR_BOOL);
		// 一括制御実行
		Property collectiverunExecute = new Property(RoleConstant.COLLECTIVERUN_EXECUTE,
				Messages.getString("collectiverun.execute", locale),
				PropertyConstant.EDITOR_BOOL);
		// カレンダ参照
		Property calendarRead = new Property(RoleConstant.CALENDAR_READ, Messages.getString(
				"calendar.read", locale), PropertyConstant.EDITOR_BOOL);
		// カレンダ設定
		Property calendarWrite = new Property(RoleConstant.CALENDAR_WRITE, Messages
				.getString("calendar.write", locale),
				PropertyConstant.EDITOR_BOOL);
		// 通知参照
		Property notifyRead = new Property(RoleConstant.NOTIFY_READ, Messages.getString(
				"notify.id.read", locale), PropertyConstant.EDITOR_BOOL);
		// 通知設定
		Property notifyWrite = new Property(RoleConstant.NOTIFY_WRITE, Messages.getString(
				"notify.id.write", locale), PropertyConstant.EDITOR_BOOL);
		// 履歴情報削除参照
		Property maintenanceRead = new Property(RoleConstant.MAINTENANCE_READ, Messages
				.getString("maintenance.delete.history.read", locale),
				PropertyConstant.EDITOR_BOOL);
		// 履歴情報削除設定
		Property maintenanceWrite = new Property(RoleConstant.MAINTENANCE_WRITE, Messages
				.getString("maintenance.delete.history.write", locale),
				PropertyConstant.EDITOR_BOOL);
		// 仮想化管理参照
		Property vmManagementRead = new Property(RoleConstant.VMMANAGEMENT_READ, Messages
				.getString("vm.management.read", locale),
				PropertyConstant.EDITOR_BOOL);
		// 仮想化管理設定
		Property vmManagementWrite = new Property(RoleConstant.VMMANAGEMENT_WRITE, Messages
				.getString("vm.management.write", locale),
				PropertyConstant.EDITOR_BOOL);
		// 仮想化管理実行
		Property vmManagementExecute = new Property(RoleConstant.VMMANAGEMENT_EXECUTE,
				Messages.getString("vm.management.execute", locale),
				PropertyConstant.EDITOR_BOOL);
		// クラウド管理参照
		Property cloudManagementRead = new Property(RoleConstant.CLOUDMANAGEMENT_READ, Messages
				.getString("cloud.management.read", locale),
				PropertyConstant.EDITOR_BOOL);
		// クラウド管理設定
		Property cloudManagementWrite = new Property(RoleConstant.CLOUDMANAGEMENT_WRITE, Messages
				.getString("cloud.management.write", locale),
				PropertyConstant.EDITOR_BOOL);
		// クラウド管理実行
		Property cloudManagementExecute = new Property(RoleConstant.CLOUDMANAGEMENT_EXECUTE,
				Messages.getString("cloud.management.execute", locale),
				PropertyConstant.EDITOR_BOOL);

		// 値を初期化
		uid.setValue("");
		name.setValue("");
		description.setValue("");

		access.setValue("");
		repositoryRead.setValue(Boolean.valueOf(false));
		repositoryWrite.setValue(Boolean.valueOf(false));
		repositoryExecute.setValue(Boolean.valueOf(false));
		accessRead.setValue(Boolean.valueOf(false));
		accessWrite.setValue(Boolean.valueOf(false));
		monitorResultRead.setValue(Boolean.valueOf(false));
		monitorResultWrite.setValue(Boolean.valueOf(false));
		monitorSettingRead.setValue(Boolean.valueOf(false));
		monitorSettingWrite.setValue(Boolean.valueOf(false));
		jobManagementRead.setValue(Boolean.valueOf(false));
		jobManagementWrite.setValue(Boolean.valueOf(false));
		jobManagementExecute.setValue(Boolean.valueOf(false));
		performanceRead.setValue(Boolean.valueOf(false));
		performanceExecute.setValue(Boolean.valueOf(false));
		collectiverunRead.setValue(Boolean.valueOf(false));
		collectiverunWrite.setValue(Boolean.valueOf(false));
		collectiverunExecute.setValue(Boolean.valueOf(false));
		calendarRead.setValue(Boolean.valueOf(false));
		calendarWrite.setValue(Boolean.valueOf(false));
		notifyRead.setValue(Boolean.valueOf(false));
		notifyWrite.setValue(Boolean.valueOf(false));
		maintenanceRead.setValue(Boolean.valueOf(false));
		maintenanceWrite.setValue(Boolean.valueOf(false));
		vmManagementRead.setValue(Boolean.valueOf(false));
		vmManagementWrite.setValue(Boolean.valueOf(false));
		vmManagementExecute.setValue(Boolean.valueOf(false));
		cloudManagementRead.setValue(Boolean.valueOf(false));
		cloudManagementWrite.setValue(Boolean.valueOf(false));
		cloudManagementExecute.setValue(Boolean.valueOf(false));

		// 変更可及びコピー可を設定
		uid.setModify(PropertyConstant.MODIFY_OK);
		name.setModify(PropertyConstant.MODIFY_OK);
		description.setModify(PropertyConstant.MODIFY_OK);
		repositoryRead.setModify(PropertyConstant.MODIFY_OK);
		repositoryWrite.setModify(PropertyConstant.MODIFY_OK);
		repositoryExecute.setModify(PropertyConstant.MODIFY_OK);
		accessRead.setModify(PropertyConstant.MODIFY_OK);
		accessWrite.setModify(PropertyConstant.MODIFY_OK);
		monitorResultRead.setModify(PropertyConstant.MODIFY_OK);
		monitorResultWrite.setModify(PropertyConstant.MODIFY_OK);
		monitorSettingRead.setModify(PropertyConstant.MODIFY_OK);
		monitorSettingWrite.setModify(PropertyConstant.MODIFY_OK);
		jobManagementRead.setModify(PropertyConstant.MODIFY_OK);
		jobManagementWrite.setModify(PropertyConstant.MODIFY_OK);
		jobManagementExecute.setModify(PropertyConstant.MODIFY_OK);
		performanceRead.setModify(PropertyConstant.MODIFY_OK);
		performanceExecute.setModify(PropertyConstant.MODIFY_OK);
		collectiverunRead.setModify(PropertyConstant.MODIFY_OK);
		collectiverunWrite.setModify(PropertyConstant.MODIFY_OK);
		collectiverunExecute.setModify(PropertyConstant.MODIFY_OK);
		calendarRead.setModify(PropertyConstant.MODIFY_OK);
		calendarWrite.setModify(PropertyConstant.MODIFY_OK);
		notifyRead.setModify(PropertyConstant.MODIFY_OK);
		notifyWrite.setModify(PropertyConstant.MODIFY_OK);
		maintenanceRead.setModify(PropertyConstant.MODIFY_OK);
		maintenanceWrite.setModify(PropertyConstant.MODIFY_OK);
		vmManagementRead.setModify(PropertyConstant.MODIFY_OK);
		vmManagementWrite.setModify(PropertyConstant.MODIFY_OK);
		vmManagementExecute.setModify(PropertyConstant.MODIFY_OK);
		cloudManagementRead.setModify(PropertyConstant.MODIFY_OK);
		cloudManagementWrite.setModify(PropertyConstant.MODIFY_OK);
		cloudManagementExecute.setModify(PropertyConstant.MODIFY_OK);
		
		Property property = new Property(null, null, "");

		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(uid);
		property.addChildren(name);
		property.addChildren(description);
		property.addChildren(access);

		// アクセス権限ツリー
		access.removeChildren();
		access.addChildren(repositoryRead);
		access.addChildren(repositoryWrite);
		access.addChildren(repositoryExecute);
		access.addChildren(accessRead);
		access.addChildren(accessWrite);
		access.addChildren(monitorResultRead);
		access.addChildren(monitorResultWrite);
		access.addChildren(monitorSettingRead);
		access.addChildren(monitorSettingWrite);
		access.addChildren(jobManagementRead);
		access.addChildren(jobManagementWrite);
		access.addChildren(jobManagementExecute);
		access.addChildren(performanceRead);
		access.addChildren(performanceExecute);
		access.addChildren(collectiverunRead);
		access.addChildren(collectiverunWrite);
		access.addChildren(collectiverunExecute);
		access.addChildren(calendarRead);
		access.addChildren(calendarWrite);
		access.addChildren(notifyRead);
		access.addChildren(notifyWrite);
		access.addChildren(maintenanceRead);
		access.addChildren(maintenanceWrite);

		// VM管理オプションが適用されている場合
		access.addChildren(vmManagementRead);
		access.addChildren(vmManagementWrite);
		access.addChildren(vmManagementExecute);

		// クラウド管理オプションが適用されている場合
		access.addChildren(cloudManagementRead);
		access.addChildren(cloudManagementWrite);
		access.addChildren(cloudManagementExecute);

		m_log.debug("successful in getting properties of user's filter.");
		return property;
	}
}
