#!/bin/sh

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
MKDIR_PROC="/bin/mkdir"
CHOWN_PROC="/bin/chown"

##
## Argument setting
##
while [ $# -gt 0 ]
do
  #echo $1
  case $1 in
    -u)
      shift
      user="$1"
      ;;
    -g)
      shift
      group="$1"
      ;;
    -m)
      shift
      mode="-m $1"
      ;;
    *)
      # directory name
      dirname=$1
      ;;
  esac

  shift

done

##
## Check on user-name
##
if [ ${#user} -eq 0 ] ; then
    echo 'The user is not specified.' 1>&2
    exit 11
fi

##
## Check on group-name
##
if [ ${#group} -eq 0 ] ; then
    echo 'The group is not specified.' 1>&2
    exit 12
fi

##
## mkdir command
##
echo "$MKDIR_PROC $mode $dirname"
$MKDIR_PROC $mode $dirname
if [ $? -ne 0 ] ; then
    exit 10
fi

##
## chown command
##
if [ ${#user} -ne 0 ] ; then
    ownarg=$user
fi
if [ ${#group} -ne 0 ] ; then
    ownarg=$ownarg:$group
fi
if [ ${#ownarg} -ne 0 ] ; then
    echo "$CHOWN_PROC $ownarg $dirname"
    $CHOWN_PROC $ownarg $dirname
    if [ $? -ne 0 ] ; then
        exit 1
    fi
fi

exit

