#!/bin/sh

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/../hinemos.cfg
. ${SCRIPT_DIR}/../sbin/hinemos_utility.sh

export PROG=`basename $0`
DIR=`dirname $0`
USER=`/usr/bin/whoami`
HOST=`hostname`

cd ${HINEMOS_HOME}/var/log

########################################
#  Local Variable
########################################

# log file path (pg_ctl -l option)
PG_LOGFILE="${HINEMOS_HOME}/var/log/postgresql.log"

# timeout [sec] (pg_ctl -t option)
#   this variable is valid with -W option
PG_TIMEOUT=90

########################################
#  Local Message
########################################

# INFO
MSG_I001="PostgreSQL started"
MSG_I002="waiting for PostgreSQL to start..."

# WARN
#MSG_W001="xxx"

# ERROR
MSG_E001="usage : ${PROG} [-W]"
MSG_E002="failed to start PostgreSQL"
MSG_E003="incorrect user ('${USER}')"
MSG_E004="execute this script at '${HINEMOS_PG_USER}' user."

########################################
# Function
########################################


########################################
# SHELL
########################################

#
# check argument
#
PG_STARTUP_WAIT="true"
for ARGS in "$@"
do
	case ${ARGS} in
		-W)
			PG_STARTUP_WAIT="false"
			;;
		*)
			Logging "${MSG_E001}"
			exit -1
			;;
	esac
done

#
# check user executed
#
if [ "x"${USER} != "x"${HINEMOS_PG_USER} ] && [ "x"${USER} != "x"${HINEMOS_JBOSS_USER} ]
then
	Logging "${MSG_E003}"
	Logging "${MSG_E004}"
	exit -2
fi

#
# startup PostgreSQL
#
Logging "${MSG_I002}"
ABOUT_STARTUP=""
if [ "x"${PG_STARTUP_WAIT} = "xtrue" ]
then
	if [ "x"${USER} = "x"${HINEMOS_PG_USER} ]
	then
		${PG_HOME}/bin/pg_ctl start -w -t ${PG_TIMEOUT} -s -D ${PG_DATA} -l ${PG_LOGFILE}
	else
		su -c "${PG_HOME}/bin/pg_ctl start -w -t ${PG_TIMEOUT} -s -D ${PG_DATA} -l ${PG_LOGFILE}" - ${HINEMOS_PG_USER}
	fi
else
	ABOUT_STARTUP=" (with -W option)"
	if [ "x"${USER} = "x"${HINEMOS_PG_USER} ]
	then
		${PG_HOME}/bin/pg_ctl start -s -D ${PG_DATA} -l ${PG_LOGFILE}
	else
		su -c "${PG_HOME}/bin/pg_ctl start -s -D ${PG_DATA} -l ${PG_LOGFILE}" - ${HINEMOS_PG_USER}
	fi
fi
RET=$?

if [ ${RET} -eq 0 ]
then
	Logging "${MSG_I001}${ABOUT_STARTUP}"
else
	Logging "${MSG_E002}"
fi

exit ${RET}
