/*

Copyright (C) 2011 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

 */


package com.clustercontrol.sharedtable.ejb.session;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.sharedtable.SharedTable;

/**
 *　スケジューラ(Quartz)からキックされるアーカイブ情報削除処理の実行クラス
 * 
 * @ejb.bean name="CheckJob"
 *           jndi-name="CheckJob"
 *           type="Stateless"
 *           transaction-type="Container"
 *           view-type="local"
 * 
 * @ejb.transaction type="Required"
 * 
 * @ejb.permission
 *     unchecked="true"
 */
public abstract class CheckJobBean implements SessionBean {

	private static Log log = LogFactory.getLog( CheckJobBean.class );

	public static final String METHOD_NAME = "run";

	/** コンテキスト情報。 */
	@SuppressWarnings("unused")
	private SessionContext m_context;

	/**
	 * コンテキスト情報を設定します。<BR>
	 * Session Bean の生成時に行う処理を実装します。
	 * @see javax.ejb.SessionBean#setSessionContext(javax.ejb.SessionContext)
	 */
	@Override
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}

	/**
	 * Quartzからのコールバックメソッド<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * Database commit後に実施すべきユーザ実装が存在するため、トランザクション開始はユーザが制御する。
	 * また、追加実装により、トランザクションの入れ子が予期せず生じることを避けるため、Neverを採用する。
	 * @ejb.transaction type="Never"
	 * 
	 * @since 4.0.0
	 */
	public void run(String jndiName) {
		// デバッグログ出力
		log.debug("Check Job Execute : start.");

		// 共有テーブルを取得する
		try {
			InitialContext ctx = new InitialContext();

			Object obj = ctx.lookup(jndiName);
			SharedTable sharedTable =
				(SharedTable)PortableRemoteObject.narrow(obj, SharedTable.class);

			// 不要なテーブルを削除
			sharedTable.checkUnnecessaryTable();
		} catch (NamingException e) {
			log.error(e.getMessage(), e);
		}

		// デバッグログ出力
		log.debug("Check Job Execute : end.");
	}

}
