/*

Copyright (C) 2010 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.selfcheck.monitor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import com.clustercontrol.notify.bean.OutputBasicInfo;

/**
 * Syslogのフィルタの更新状況を確認する処理の実装クラス(未実装)
 */
public class SyslogFilterMonitor extends SelfCheckMonitorBase {

	private static Log m_log = LogFactory.getLog( SyslogFilterMonitor.class );

	private static final String monitorIdPrefix = "SYS_SYSLOG";
	private String monitorId = "";
	private String application = "SELFCHECK (SyslogFilter)";

	private String ipAddress = "";

	/**
	 * コンストラクタ
	 * @param jvmMinHeapThreshold Java VMの利用可能なヒープ容量の最小値
	 */
	public SyslogFilterMonitor(String ipAddress) {
		this.ipAddress = ipAddress;

		this.monitorId = monitorIdPrefix + "_SyslogFilter_" + ipAddress;
	}

	/**
	 * セルフチェック処理名
	 */
	@Override
	public String toString() {
		return "monitoring syslog filter";
	}

	/**
	 * 監視項目ID
	 */
	@Override
	public String getMonitorId() {
		return monitorId;
	}

	/**
	 * Syslogのフィルタの更新状況を確認する処理
	 * @return 通知情報（アプリケーション名は未格納）
	 */
	@Override
	@SuppressWarnings("unchecked")
	public OutputBasicInfo execute() {
		// do nothing
		// TODO : implement logic for monitoring syslog filter on jboss
		m_log.warn("this class is not implemented yet.");
		return null;
	}

}
