/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.jmx;

import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.monitor.ejb.session.MonitorSettingControllerLocal;
import com.clustercontrol.monitor.ejb.session.MonitorSettingControllerUtil;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.performance.monitor.factory.ModifyPollingSchedule;

/**
 * リソース監視機能用性能値収集を再実行するクラス
 *
 */
public class PerformanceRestartManager {
	private static Log m_log = LogFactory.getLog( PerformanceRestartManager.class );

	/**
	 * 状態が「実行中」である収集を再開します
	 */
	public void restartAll() {
		m_log.info("MONITOR_PERFORMANCE : poller restart!!");

		try{
			// 監視一覧を取得
			MonitorSettingControllerLocal perfMonitor = MonitorSettingControllerUtil.getLocalHome().create();
			ArrayList<MonitorInfo> monitorInfoList = perfMonitor.getPerformanceList();

			// リソース監視なら再スケジュール
			ModifyPollingSchedule poller = new ModifyPollingSchedule();
			for(MonitorInfo monitorInfo : monitorInfoList){
				// ポーラに登録
				m_log.debug("restartAll() target monitorId = " + monitorInfo.getMonitorId()
						+ ", MonitorFlg = " + monitorInfo.getMonitorFlg()
						+ ", CollectorFlg = " + monitorInfo.getCollectorFlg());

				boolean status = true;
				if(monitorInfo.getMonitorFlg() == YesNoConstant.TYPE_YES
						|| monitorInfo.getCollectorFlg() == YesNoConstant.TYPE_YES){
					status = poller.addSchedule(monitorInfo);
				}

				if(!status){
					m_log.error("restartAll() monitorId = " + monitorInfo.getMonitorId());
				}
			}

		} catch (CreateException e) {
			m_log.error("restartAll()", e);
		} catch (NamingException e) {
			m_log.error("restartAll()", e);
		} catch (HinemosUnknown e) {
			m_log.error("restartAll()", e);
		} catch (MonitorNotFound e) {
			m_log.error("restartAll()", e);
		}
	}

}
