/*
Copyright (C) 2010 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.nodemap.ejb.entity;

import java.lang.String;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 *
 * <!-- begin-user-doc --> マップ描画対象ノード（スコープ）の位置情報を保持するEntityBean '<em><b>BgImageBean</b></em>'. <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="IconImage"
 *	jndi-name="IconImage"
 *	type="CMP"
 *  view-type = "local"
 *  schema="IconImage"
 *  cmp-version="2.x"
 *  data-source="java:/DefaultDS"
 *  primkey-field="filename"
 * 
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 * @ejb.persistence
 *   table-name="cc_map_icon_image"
 * 
 * @ejb.permission
 *     unchecked="true"
 * 
 * @ejb.finder
 *    query="SELECT OBJECT(a) FROM IconImage as a"
 *    signature="java.util.Collection findAll()"
 * 
 * @ejb.pk class="java.lang.String"
 *
 * <!-- end-xdoclet-definition -->
 * @generated
 **/
public abstract class IconImageBean implements javax.ejb.EntityBean {
	protected static Log m_log = LogFactory.getLog( IconImageBean.class );

	/**
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.create-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public java.lang.String ejbCreate(
			String filename,
			byte[] filedata
	) throws javax.ejb.CreateException {
		setFilename(filename);
		setFiledata(filedata);
		return null;
	}


	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		// begin-user-code
		// end-user-code
	}

	/**
	 * <!-- begin-user-doc -->
	 * CMP Field filename
	 *
	 * Returns the filename
	 * @return the filename
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="filename"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 * 
	 * @ejb.pk-field
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getFilename();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the filename
	 * 
	 * @param String filename
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setFilename(String filename);

	/**
	 * <!-- begin-user-doc -->
	 * CMP Field filedata
	 *
	 * Returns the filedata
	 * @return the filedata
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="filedata"
	 *     jdbc-type="VARBINARY"
	 *     sql-type="BYTEA"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract byte[] getFiledata();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the filedata
	 * 
	 * @param byte[] filedata
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setFiledata(byte[] filedata);
}
