/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.monitor.factory;

import java.util.ArrayList;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.monitor.bean.StatusDataInfo;
import com.clustercontrol.notify.monitor.ejb.entity.StatusInfoLocal;
import com.clustercontrol.notify.monitor.ejb.entity.StatusInfoPK;
import com.clustercontrol.notify.monitor.ejb.entity.StatusInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;


/**
 * ステータス情報を削除するクラス<BR>
 *
 * @version 3.0.0
 * @since 2.0.0
 */
public class DeleteStatus {

	/** ログ出力のインスタンス */
	private static Log m_log = LogFactory.getLog( DeleteStatus.class );

	/**
	 * 引数で指定されたステータス情報一覧を削除します。<BR>
	 * 
	 * 引数のlistは、StatusDataInfoが格納されたArrayListとして渡されます。<BR>
	 * 
	 * @param list 削除対象のステータス情報一覧（StatusDataInfoのList）
	 * @return 削除に成功した場合、</code> true </code>
	 * @throws NamingException
	 * @throws RemoveException
	 * @throws MonitorNotFound
	 * 
	 * @see com.clustercontrol.monitor.bean.StatusTabelDefine
	 * @see #delete(String, String, String)
	 */
	public boolean delete(ArrayList<StatusDataInfo> list) throws NamingException, FinderException, RemoveException, MonitorNotFound {
		String monitorId = "";
		String monitorDetailId = "";
		String pluginId = "";
		String facilityId = "";
		try{
			if (list != null && list.size()>0) {
				for(StatusDataInfo status : list){
					monitorId = status.getMonitorId();
					monitorDetailId = status.getMonitorDetailId();
					pluginId = status.getPluginId();
					facilityId = status.getFacilityId();
					if (status != null) {
						// ステータス情報を取得
						StatusInfoPK pk = new StatusInfoPK(monitorId, monitorDetailId, pluginId, facilityId);

						StatusInfoLocal statusInfo = StatusInfoUtil.getLocalHome().findByPrimaryKey(pk);

						statusInfo.remove();
					}
				}
			}
		}catch (FinderException e) {
			AplLogger apllog = new AplLogger("MON", "mon");
			String[] args = {facilityId, monitorId, pluginId};
			apllog.put("SYS", "004", args);
			m_log.debug("delete():" + e.getMessage());
			throw new MonitorNotFound(e.getMessage(), e);
		} catch (RemoveException e) {
			AplLogger apllog = new AplLogger("MON", "mon");
			String[] args = {facilityId, monitorId, pluginId};
			apllog.put("SYS", "004", args);
			m_log.debug("delete():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("MON", "mon");
			String[] args = {facilityId, monitorId, pluginId};
			apllog.put("SYS", "004", args);
			m_log.debug("delete():" + e.getMessage());
			throw e;
		}
		return true;
	}
}

