/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.ejb.entity;

import java.sql.Time;
import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;


/**
 * ジョブ待ち条件マスタのBMP Entity Bean クラス<BR>
 * 
 * @ejb.bean name="JobStartMaster"
 *    jndi-name="JobStartMaster"
 *    type="BMP"
 *    view-type="local"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config BMP EntityBean"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 * @ejb.dao
 *    class="com.clustercontrol.jobmanagement.dao.JobStartMasterDAO"
 *    impl-class="com.clustercontrol.jobmanagement.dao.JobStartMasterDAOImpl"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @see com.clustercontrol.jobmanagement.dao.JobStartMasterDAO
 * @see com.clustercontrol.jobmanagement.dao.JobStartMasterDAOImpl
 */
public abstract class JobStartMasterBean implements javax.ejb.EntityBean {
	/** 所属ジョブユニットのジョブID **/
	protected String jobunit_id;
	/** ジョブID */
	protected String job_id;
	/** 判定対象の条件関係 */
	protected Integer condition_type;
	/** 保留 */
	protected Integer suspend;
	/** スキップ */
	protected Integer skip;
	/** スキップ時終了状態 */
	protected Integer skip_end_status;
	/** スキップ時終了値 */
	protected Integer skip_end_value;
	/** 条件を満たさなければ終了する */
	protected Integer unmatch_end_flg;
	/** 条件を満たさない時の終了状態 */
	protected Integer unmatch_end_status;
	/** 条件を満たさない時の終了値 */
	protected Integer unmatch_end_value;
	/** カレンダ */
	protected Integer calendar;
	/** カレンダID */
	protected String  calendar_id;
	/** カレンダにより未実行時の終了値 */
	protected Integer calendar_end_value;
	/** 開始遅延 */
	protected Integer start_delay;
	/** 開始遅延セッション開始後の時間 */
	protected Integer start_delay_session;
	/** 開始遅延セッション開始後の時間の値 */
	protected Integer start_delay_session_value;
	/** 開始遅延時刻 */
	protected Integer start_delay_time;
	/** 開始遅延時刻の値 */
	protected Time start_delay_time_value;
	/** 開始遅延判定対象の条件関係 */
	protected Integer start_delay_condition_type;
	/** 開始遅延通知 */
	protected Integer start_delay_notify;
	/** 開始遅延通知重要度 */
	protected Integer start_delay_notify_priority;
	/** 開始遅延操作 */
	protected Integer start_delay_operation;
	/** 開始遅延操作種別 */
	protected Integer start_delay_operation_type;
	/** 開始遅延操作終了値 */
	protected Integer start_delay_operation_end_value;
	/** 終了遅延 */
	protected Integer end_delay;
	/** 終了遅延セッション開始後の時間 */
	protected Integer end_delay_session;
	/** 終了遅延セッション開始後の時間の値 */
	protected Integer end_delay_session_value;
	/** 終了遅延ジョブ開始後の時間 */
	protected Integer end_delay_job;
	/** 終了遅延ジョブ開始後の時間の値 */
	protected Integer end_delay_job_value;
	/** 終了遅延時刻 */
	protected Integer end_delay_time;
	/** 終了遅延時刻の値 */
	protected Time end_delay_time_value;
	/** 終了遅延判定対象の条件関係 */
	protected Integer end_delay_condition_type;
	/** 終了遅延通知 */
	protected Integer end_delay_notify;
	/** 終了遅延通知重要度 */
	protected Integer end_delay_notify_priority;
	/** 終了遅延操作 */
	protected Integer end_delay_operation;
	/** 終了遅延操作種別 */
	protected Integer end_delay_operation_type;
	/** 終了遅延操作終了値 */
	protected Integer end_delay_operation_end_value;

	/**
	 * ジョブコマンドマスタを生成します。
	 * 
	 * @ejb.create-method
	 * 
	 * @param jobunit_id 所属ジョブユニットのジョブID
	 * @param job_id ジョブID
	 * @param condition_type 判定対象の条件関係
	 * @param suspend 保留
	 * @param skip スキップ
	 * @param skip_end_status スキップ時終了状態
	 * @param skip_end_value スキップ時終了値
	 * @param unmatch_end_flg 条件を満たさなければ終了する
	 * @param unmatch_end_status 条件を満たさない時の終了状態
	 * @param unmatch_end_value 条件を満たさない時の終了値
	 * @param calendar カレンダ
	 * @param calendar_id カレンダID
	 * @param calendar_end_value カレンダにより未実行時の終了値
	 * @param start_delay 開始遅延
	 * @param start_delay_session 開始遅延セッション開始後の時間
	 * @param start_delay_session_value 開始遅延セッション開始後の時間の値
	 * @param start_delay_time 開始遅延時刻
	 * @param start_delay_time_value 開始遅延時刻の値
	 * @param start_delay_condition_type 開始遅延判定対象の条件関係
	 * @param start_delay_notify 開始遅延通知
	 * @param start_delay_notify_priority 開始遅延通知重要度
	 * @param start_delay_operation 開始遅延操作
	 * @param start_delay_operation_type 開始遅延操作種別
	 * @param start_delay_operation_end_value 開始遅延操作終了値
	 * @param end_delay 終了遅延
	 * @param end_delay_session 終了遅延セッション開始後の時間
	 * @param end_delay_session_value 終了遅延セッション開始後の時間の値
	 * @param end_delay_job 終了遅延ジョブ開始後の時間
	 * @param end_delay_job_value 終了遅延ジョブ開始後の時間の値
	 * @param end_delay_time 終了遅延時刻
	 * @param end_delay_time_value 終了遅延時刻の値
	 * @param end_delay_condition_type 終了遅延判定対象の条件関係
	 * @param end_delay_notify 終了遅延通知
	 * @param end_delay_notify_priority 終了遅延通知重要度
	 * @param end_delay_operation 終了遅延操作
	 * @param end_delay_operation_type 終了遅延操作種別
	 * @param end_delay_operation_end_value 終了遅延操作終了値
	 * @return プライマリーキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 * @see com.clustercontrol.bean.EndStatusConstant
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.jobmanagement.bean.ConditionTypeConstant
	 * @see com.clustercontrol.jobmanagement.bean.OperationConstant
	 */
	public JobStartMasterPK ejbCreate(
			String jobuString,
			String job_id,
			Integer condition_type,
			Integer suspend,
			Integer skip,
			Integer skip_end_status,
			Integer skip_end_value,
			Integer unmatch_end_flg,
			Integer unmatch_end_status,
			Integer unmatch_end_value,
			Integer calendar,
			String  calendar_id,
			Integer calendar_end_value,
			Integer start_delay,
			Integer start_delay_session,
			Integer start_delay_session_value,
			Integer start_delay_time,
			Time start_delay_time_value,
			Integer start_delay_condition_type,
			Integer start_delay_notify,
			Integer start_delay_notify_priority,
			Integer start_delay_operation,
			Integer start_delay_operation_type,
			Integer start_delay_operation_end_value,
			Integer end_delay,
			Integer end_delay_session,
			Integer end_delay_session_value,
			Integer end_delay_job,
			Integer end_delay_job_value,
			Integer end_delay_time,
			Time end_delay_time_value,
			Integer end_delay_condition_type,
			Integer end_delay_notify,
			Integer end_delay_notify_priority,
			Integer end_delay_operation,
			Integer end_delay_operation_type,
			Integer end_delay_operation_end_value
	) throws javax.ejb.CreateException {
		this.jobunit_id = jobuString;
		this.job_id = job_id;
		this.condition_type = condition_type;
		this.suspend = suspend;
		this.skip = skip;
		this.skip_end_status = skip_end_status;
		this.skip_end_value = skip_end_value;
		this.unmatch_end_flg = unmatch_end_flg;
		this.unmatch_end_status = unmatch_end_status;
		this.unmatch_end_value = unmatch_end_value;
		this.calendar = calendar;
		this.calendar_id = calendar_id;
		this.calendar_end_value = calendar_end_value;
		this.start_delay = start_delay;
		this.start_delay_session = start_delay_session;
		this.start_delay_session_value = start_delay_session_value;
		this.start_delay_time = start_delay_time;
		this.start_delay_time_value = start_delay_time_value;
		this.start_delay_condition_type = start_delay_condition_type;
		this.start_delay_notify = start_delay_notify;
		this.start_delay_notify_priority = start_delay_notify_priority;
		this.start_delay_operation = start_delay_operation;
		this.start_delay_operation_type = start_delay_operation_type;
		this.start_delay_operation_end_value = start_delay_operation_end_value;
		this.end_delay = end_delay;
		this.end_delay_session = end_delay_session;
		this.end_delay_session_value = end_delay_session_value;
		this.end_delay_job = end_delay_job;
		this.end_delay_job_value = end_delay_job_value;
		this.end_delay_time = end_delay_time;
		this.end_delay_time_value = end_delay_time_value;
		this.end_delay_condition_type = end_delay_condition_type;
		this.end_delay_notify = end_delay_notify;
		this.end_delay_notify_priority = end_delay_notify_priority;
		this.end_delay_operation = end_delay_operation;
		this.end_delay_operation_type = end_delay_operation_type;
		this.end_delay_operation_end_value = end_delay_operation_end_value;
		return null;
	}

	/**
	 * 全てのジョブ待ち条件マスタを検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobStartMasterDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}

	/**
	 * プライマリキーに一致するジョブ待ち条件マスタを検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobStartMasterDAOImpl#findByPrimaryKey(JobStartMasterPK)
	 */
	public JobStartMasterPK ejbFindByPrimaryKey(JobStartMasterPK pk) throws FinderException {
		return null;
	}

	/**
	 * 所属ジョブユニットのジョブIDを返す。<BR>
	 * 
	 * @ejb.persistent-field
	 * @ejb.pk-field
	 * @ejb.interface-method
	 * 
	 * @return 所属ジョブユニットのジョブID
	 */
	public java.lang.String getJobunit_id() {
		return jobunit_id;
	}

	/**
	 * 所属ジョブユニットのジョブIDを設定する。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobunit_id 所属ジョブユニットのジョブID
	 */
	public void setJobunit_id(java.lang.String jobunit_id) {
		this.jobunit_id = jobunit_id;
	}

	/**
	 * ジョブIDを返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.pk-field
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
	public java.lang.String getJob_id() {
		return job_id;
	}

	/**
	 * ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
	public void setJob_id(java.lang.String job_id) {
		this.job_id = job_id;
	}

	/**
	 * 判定対象の条件関係を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 判定対象の条件関係
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.ConditionTypeConstant
	 */
	public java.lang.Integer getCondition_type() {
		return condition_type;
	}

	/**
	 * 判定対象の条件関係を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param condition_type 判定対象の条件関係
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.ConditionTypeConstant
	 */
	public void setCondition_type(java.lang.Integer condition_type) {
		this.condition_type = condition_type;
	}

	/**
	 * 保留を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 保留
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public java.lang.Integer getSuspend() {
		return suspend;
	}

	/**
	 * 保留を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param suspend 保留
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setSuspend(java.lang.Integer suspend) {
		this.suspend = suspend;
	}

	/**
	 * スキップを返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return スキップ
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public java.lang.Integer getSkip() {
		return skip;
	}

	/**
	 * スキップを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param skip スキップ
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setSkip(java.lang.Integer skip) {
		this.skip = skip;
	}

	/**
	 * スキップ時終了状態を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return スキップ時終了状態
	 * 
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public java.lang.Integer getSkip_end_status() {
		return skip_end_status;
	}

	/**
	 * スキップ時終了状態を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param skip_end_status
	 * 
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public void setSkip_end_status(
			java.lang.Integer skip_end_status) {
		this.skip_end_status = skip_end_status;
	}

	/**
	 * スキップ時終了値を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return スキップ時終了値
	 */
	public java.lang.Integer getSkip_end_value() {
		return skip_end_value;
	}

	/**
	 * スキップ時終了値を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param skip_end_value スキップ時終了値
	 */
	public void setSkip_end_value(
			java.lang.Integer skip_end_value) {
		this.skip_end_value = skip_end_value;
	}

	/**
	 * 条件を満たさなければ終了するを返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 条件を満たさなければ終了する
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public java.lang.Integer getUnmatch_end_flg() {
		return unmatch_end_flg;
	}

	/**
	 * 条件を満たさなければ終了するを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param unmatch_end_flg 条件を満たさなければ終了する
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setUnmatch_end_flg(java.lang.Integer unmatch_end_flg) {
		this.unmatch_end_flg = unmatch_end_flg;
	}

	/**
	 * 条件を満たさない時の終了状態を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 条件を満たさない時の終了状態
	 * 
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public java.lang.Integer getUnmatch_end_status() {
		return unmatch_end_status;
	}

	/**
	 * 条件を満たさない時の終了状態を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param unmatch_end_status 条件を満たさない時の終了状態
	 * 
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public void setUnmatch_end_status(
			java.lang.Integer unmatch_end_status) {
		this.unmatch_end_status = unmatch_end_status;
	}

	/**
	 * 条件を満たさない時の終了値を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 条件を満たさない時の終了値
	 */
	public java.lang.Integer getUnmatch_end_value() {
		return unmatch_end_value;
	}

	/**
	 * 条件を満たさない時の終了値を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param unmatch_end_value 条件を満たさない時の終了値
	 */
	public void setUnmatch_end_value(java.lang.Integer unmatch_end_value) {
		this.unmatch_end_value = unmatch_end_value;
	}

	/**
	 * カレンダを返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return カレンダ
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public java.lang.Integer getCalendar() {
		return calendar;
	}

	/**
	 * カレンダを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param calendar カレンダ
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setCalendar(java.lang.Integer calendar) {
		this.calendar = calendar;
	}

	/**
	 * カレンダIDを返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return カレンダID
	 */
	public java.lang.String getCalendar_id() {
		return calendar_id;
	}

	/**
	 * カレンダIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param calendar_id カレンダID
	 */
	public void setCalendar_id(java.lang.String calendar_id) {
		this.calendar_id = calendar_id;
	}

	/**
	 * カレンダにより未実行時の終了値を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return カレンダにより未実行時の終了値
	 */
	public java.lang.Integer getCalendar_end_value() {
		return calendar_end_value;
	}

	/**
	 * カレンダにより未実行時の終了値を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param calendar_end_value カレンダにより未実行時の終了値
	 */
	public void setCalendar_end_value(java.lang.Integer calendar_end_value) {
		this.calendar_end_value = calendar_end_value;
	}

	/**
	 * 開始遅延を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 開始遅延
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public java.lang.Integer getStart_delay() {
		return start_delay;
	}

	/**
	 * 開始遅延を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param start_delay 開始遅延
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setStart_delay(java.lang.Integer start_delay) {
		this.start_delay = start_delay;
	}

	/**
	 * 開始遅延セッション開始後の時間を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 開始遅延セッション開始後の時間
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public java.lang.Integer getStart_delay_session() {
		return start_delay_session;
	}

	/**
	 * 開始遅延セッション開始後の時間を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param start_delay_session 開始遅延セッション開始後の時間
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setStart_delay_session(java.lang.Integer start_delay_session) {
		this.start_delay_session = start_delay_session;
	}

	/**
	 * 開始遅延セッション開始後の時間の値を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 開始遅延セッション開始後の時間の値
	 */
	public java.lang.Integer getStart_delay_session_value() {
		return start_delay_session_value;
	}

	/**
	 * 開始遅延セッション開始後の時間の値を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param start_delay_session_value 開始遅延セッション開始後の時間の値
	 */
	public void setStart_delay_session_value(java.lang.Integer start_delay_session_value) {
		this.start_delay_session_value = start_delay_session_value;
	}

	/**
	 * 開始遅延時刻を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 開始遅延時刻
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public java.lang.Integer getStart_delay_time() {
		return start_delay_time;
	}

	/**
	 * 開始遅延時刻を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param start_delay_time 開始遅延時刻
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setStart_delay_time(java.lang.Integer start_delay_time) {
		this.start_delay_time = start_delay_time;
	}

	/**
	 * 開始遅延時刻の値を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 開始遅延時刻の値
	 */
	public java.sql.Time getStart_delay_time_value() {
		return start_delay_time_value;
	}

	/**
	 * 開始遅延時刻の値を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param start_delay_time_value 開始遅延時刻の値
	 */
	public void setStart_delay_time_value(java.sql.Time start_delay_time_value) {
		this.start_delay_time_value = start_delay_time_value;
	}

	/**
	 * 開始遅延判定対象の条件関係を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 開始遅延判定対象の条件関係
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.ConditionTypeConstant
	 */
	public java.lang.Integer getStart_delay_condition_type() {
		return start_delay_condition_type;
	}

	/**
	 * 開始遅延判定対象の条件関係を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param start_delay_condition_type 開始遅延判定対象の条件関係
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.ConditionTypeConstant
	 */
	public void setStart_delay_condition_type(java.lang.Integer start_delay_condition_type) {
		this.start_delay_condition_type = start_delay_condition_type;
	}

	/**
	 * 開始遅延通知を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 開始遅延通知
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public java.lang.Integer getStart_delay_notify() {
		return start_delay_notify;
	}

	/**
	 * 開始遅延通知を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param start_delay_notify 開始遅延通知
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setStart_delay_notify(java.lang.Integer start_delay_notify) {
		this.start_delay_notify = start_delay_notify;
	}

	/**
	 * 開始遅延通知重要度を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 開始遅延通知重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public java.lang.Integer getStart_delay_notify_priority() {
		return start_delay_notify_priority;
	}

	/**
	 * 開始遅延通知重要度を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param start_delay_notify_priority 開始遅延通知重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public void setStart_delay_notify_priority(java.lang.Integer start_delay_notify_priority) {
		this.start_delay_notify_priority = start_delay_notify_priority;
	}

	/**
	 * 開始遅延操作を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 開始遅延操作
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public java.lang.Integer getStart_delay_operation() {
		return start_delay_operation;
	}

	/**
	 * 開始遅延操作を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param start_delay_operation 開始遅延操作
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setStart_delay_operation(java.lang.Integer start_delay_operation) {
		this.start_delay_operation = start_delay_operation;
	}

	/**
	 * 開始遅延操作種別を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 開始遅延操作種別
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.OperationConstant
	 */
	public java.lang.Integer getStart_delay_operation_type() {
		return start_delay_operation_type;
	}

	/**
	 * 開始遅延操作種別を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param start_delay_operation_type 開始遅延操作種別
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.OperationConstant
	 */
	public void setStart_delay_operation_type(java.lang.Integer start_delay_operation_type) {
		this.start_delay_operation_type = start_delay_operation_type;
	}

	/**
	 * 開始遅延操作終了値を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 開始遅延操作終了値
	 */
	public java.lang.Integer getStart_delay_operation_end_value() {
		return start_delay_operation_end_value;
	}

	/**
	 * 開始遅延操作終了値を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param start_delay_operation_end_value 開始遅延操作終了値
	 */
	public void setStart_delay_operation_end_value(java.lang.Integer start_delay_operation_end_value) {
		this.start_delay_operation_end_value = start_delay_operation_end_value;
	}

	/**
	 * 終了遅延を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 終了遅延
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public java.lang.Integer getEnd_delay() {
		return end_delay;
	}

	/**
	 * 終了遅延を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param end_delay 終了遅延
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setEnd_delay(java.lang.Integer end_delay) {
		this.end_delay = end_delay;
	}

	/**
	 * 終了遅延セッション開始後の時間を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 終了遅延セッション開始後の時間
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public java.lang.Integer getEnd_delay_session() {
		return end_delay_session;
	}

	/**
	 * 終了遅延セッション開始後の時間を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param end_delay_session 終了遅延セッション開始後の時間
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setEnd_delay_session(java.lang.Integer end_delay_session) {
		this.end_delay_session = end_delay_session;
	}

	/**
	 * 終了遅延セッション開始後の時間の値を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 終了遅延セッション開始後の時間の値
	 */
	public java.lang.Integer getEnd_delay_session_value() {
		return end_delay_session_value;
	}

	/**
	 * 終了遅延セッション開始後の時間の値を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param end_delay_session_value 終了遅延セッション開始後の時間の値
	 */
	public void setEnd_delay_session_value(java.lang.Integer end_delay_session_value) {
		this.end_delay_session_value = end_delay_session_value;
	}

	/**
	 * 終了遅延ジョブ開始後の時間の値を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 終了遅延ジョブ開始後の時間の値
	 */
	public java.lang.Integer getEnd_delay_job() {
		return end_delay_job;
	}

	/**
	 * 終了遅延ジョブ開始後の時間を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param end_delay_job 終了遅延ジョブ開始後の時間
	 */
	public void setEnd_delay_job(java.lang.Integer end_delay_job) {
		this.end_delay_job = end_delay_job;
	}

	/**
	 * 終了遅延ジョブ開始後の時間の値を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 終了遅延ジョブ開始後の時間の値
	 */
	public java.lang.Integer getEnd_delay_job_value() {
		return end_delay_job_value;
	}

	/**
	 * 終了遅延ジョブ開始後の時間の値を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param end_delay_job_value 終了遅延ジョブ開始後の時間の値
	 */
	public void setEnd_delay_job_value(java.lang.Integer end_delay_job_value) {
		this.end_delay_job_value = end_delay_job_value;
	}

	/**
	 * 終了遅延時刻を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 終了遅延時刻
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public java.lang.Integer getEnd_delay_time() {
		return end_delay_time;
	}

	/**
	 * 終了遅延時刻を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param end_delay_time 終了遅延時刻
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setEnd_delay_time(java.lang.Integer end_delay_time) {
		this.end_delay_time = end_delay_time;
	}

	/**
	 * 終了遅延時刻の値を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 終了遅延時刻の値
	 */
	public java.sql.Time getEnd_delay_time_value() {
		return end_delay_time_value;
	}

	/**
	 * 終了遅延時刻の値を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param end_delay_time_value 終了遅延時刻の値
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setEnd_delay_time_value(java.sql.Time end_delay_time_value) {
		this.end_delay_time_value = end_delay_time_value;
	}

	/**
	 * 終了遅延判定対象の条件関係を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 終了遅延判定対象の条件関係
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.ConditionTypeConstant
	 */
	public java.lang.Integer getEnd_delay_condition_type() {
		return end_delay_condition_type;
	}

	/**
	 * 終了遅延判定対象の条件関係を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param end_delay_condition_type 終了遅延判定対象の条件関係
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.ConditionTypeConstant
	 */
	public void setEnd_delay_condition_type(java.lang.Integer end_delay_condition_type) {
		this.end_delay_condition_type = end_delay_condition_type;
	}

	/**
	 * 終了遅延通知を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 終了遅延通知
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public java.lang.Integer getEnd_delay_notify() {
		return end_delay_notify;
	}

	/**
	 * 終了遅延通知を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param end_delay_notify 終了遅延通知
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setEnd_delay_notify(java.lang.Integer end_delay_notify) {
		this.end_delay_notify = end_delay_notify;
	}

	/**
	 * 終了遅延通知重要度を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 終了遅延通知重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public java.lang.Integer getEnd_delay_notify_priority() {
		return end_delay_notify_priority;
	}

	/**
	 * 終了遅延通知重要度を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param end_delay_notify_priority 終了遅延通知重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public void setEnd_delay_notify_priority(java.lang.Integer end_delay_notify_priority) {
		this.end_delay_notify_priority = end_delay_notify_priority;
	}

	/**
	 * 終了遅延操作を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 終了遅延操作
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public java.lang.Integer getEnd_delay_operation() {
		return end_delay_operation;
	}

	/**
	 * 終了遅延操作を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param end_delay_operation 終了遅延操作
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setEnd_delay_operation(java.lang.Integer end_delay_operation) {
		this.end_delay_operation = end_delay_operation;
	}

	/**
	 * 終了遅延操作種別を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 終了遅延操作種別
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.OperationConstant
	 */
	public java.lang.Integer getEnd_delay_operation_type() {
		return end_delay_operation_type;
	}

	/**
	 * 終了遅延操作種別を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param end_delay_operation_type 終了遅延操作種別
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.OperationConstant
	 */
	public void setEnd_delay_operation_type(java.lang.Integer end_delay_operation_type) {
		this.end_delay_operation_type = end_delay_operation_type;
	}

	/**
	 * 終了遅延操作終了値を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 終了遅延操作終了値
	 */
	public java.lang.Integer getEnd_delay_operation_end_value() {
		return end_delay_operation_end_value;
	}

	/**
	 * 終了遅延操作終了値を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param end_delay_operation_end_value 終了遅延操作終了値
	 */
	public void setEnd_delay_operation_end_value(java.lang.Integer end_delay_operation_end_value) {
		this.end_delay_operation_end_value = end_delay_operation_end_value;
	}

	/**
	 * ジョブマスタを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブマスタ
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterBean#ejbFindByPrimaryKey(JobMasterPK)
	 */
	public JobMasterLocal getJobMaster() {
		JobMasterLocal jobMaster = null;
		try {
			jobMaster = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(getJobunit_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobMaster;
	}

	/**
	 * ジョブ待ち条件ジョブマスタを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブ待ち条件ジョブマスタ
	 * 
	 */
	public Collection getJobStartJobMaster() {
		Collection collection = null;
		try {
			collection = JobStartJobMasterUtil.getLocalHome().findByJobunitJob(getJobunit_id(), getJob_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return collection;
	}

	/**
	 * ジョブ待ち条件時刻マスタを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブ待ち条件時刻マスタ
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartTimeMasterUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartTimeMasterPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartTimeMasterBean#ejbFindByPrimaryKey(JobStartTimeMasterPK)
	 */
	public JobStartTimeMasterLocal getJobStartTimeMaster() {
		JobStartTimeMasterLocal jobStartTimeMaster = null;
		try {
			jobStartTimeMaster = JobStartTimeMasterUtil.getLocalHome().findByPrimaryKey(new JobStartTimeMasterPK(getJobunit_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobStartTimeMaster;
	}
}
