/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.jobmanagement.bean.JobConstant;
import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoPK;

/**
 * ジョブ待ち条件情報のDAOインターフェースを実装するクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 * 
 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoBean
 * @see com.clustercontrol.jobmanagement.dao.JobStartInfoDAO
 */
public class JobStartInfoDAOImpl implements JobStartInfoDAO {

	/** ログ出力のインスタンス。 */
	private static Log m_log = LogFactory.getLog(JobStartInfoDAOImpl.class);

	@Override
	public void init() {
	}

	/**
	 * SELECT文を発行します。
	 * 引数で指定されたプライマリキーで検索し、取得したデータベースの内容をEntity Beanに反映します。
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobStartInfoDAO#load(com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoPK, com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoBean)
	 */
	@Override
	public void load(JobStartInfoPK pk, JobStartInfoBean ejb) throws EJBException {
		m_log.debug("load() start : " + pk.toString());

		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;

		try {
			conn = ConnectionManager.getConnectionManager().getConnection();

			//SQL文の定義
			String sql = "SELECT * FROM cc_job_start_info WHERE session_id = ? AND job_id = ? and jobunit_id = ?";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);

			stmt.setString(1, pk.getSession_id());
			stmt.setString(2, pk.getJob_id());
			stmt.setString(3, pk.getJobunit_id());

			res = stmt.executeQuery();

			if (res.next()) {
				//取得した値をBeanにセット
				ejb.setCalendar(res.getInt("calendar"));
				ejb.setCalendar_end_value(res.getInt("calendar_end_value"));
				ejb.setCalendar_id(res.getString("calendar_id"));
				ejb.setCondition_type(res.getInt("condition_type"));
				ejb.setJob_id(res.getString("job_id"));
				ejb.setJobunit_id(res.getString("jobunit_id"));
				ejb.setSession_id(res.getString("session_id"));
				ejb.setSkip(res.getInt("skip"));
				ejb.setSkip_end_status(res.getInt("skip_end_status"));
				ejb.setSkip_end_value(res.getInt("skip_end_value"));
				ejb.setSuspend(res.getInt("suspend"));
				ejb.setUnmatch_end_flg(res.getInt("unmatch_end_flg"));
				ejb.setUnmatch_end_status(res.getInt("unmatch_end_status"));
				ejb.setUnmatch_end_value(res.getInt("unmatch_end_value"));
				ejb.setStart_delay(res.getInt("start_delay"));
				ejb.setStart_delay_condition_type(res.getInt("start_delay_condition_type"));
				ejb.setStart_delay_notify(res.getInt("start_delay_notify"));
				ejb.setStart_delay_notify_priority(res.getInt("start_delay_notify_priority"));
				ejb.setStart_delay_operation(res.getInt("start_delay_operation"));
				ejb.setStart_delay_operation_end_value(res.getInt("start_delay_operation_end_value"));
				ejb.setStart_delay_operation_type(res.getInt("start_delay_operation_type"));
				ejb.setStart_delay_session(res.getInt("start_delay_session"));
				ejb.setStart_delay_session_value(res.getInt("start_delay_session_value"));
				ejb.setStart_delay_time(res.getInt("start_delay_time"));
				ejb.setStart_delay_time_value(res.getTime("start_delay_time_value"));
				ejb.setEnd_delay(res.getInt("end_delay"));
				ejb.setEnd_delay_condition_type(res.getInt("end_delay_condition_type"));
				ejb.setEnd_delay_notify(res.getInt("end_delay_notify"));
				ejb.setEnd_delay_notify_priority(res.getInt("end_delay_notify_priority"));
				ejb.setEnd_delay_operation(res.getInt("end_delay_operation"));
				ejb.setEnd_delay_operation_end_value(res.getInt("end_delay_operation_end_value"));
				ejb.setEnd_delay_operation_type(res.getInt("end_delay_operation_type"));
				ejb.setEnd_delay_session(res.getInt("end_delay_session"));
				ejb.setEnd_delay_session_value(res.getInt("end_delay_session_value"));
				ejb.setEnd_delay_job(res.getInt("end_delay_job"));
				ejb.setEnd_delay_job_value(res.getInt("end_delay_job_value"));
				ejb.setEnd_delay_time(res.getInt("end_delay_time"));
				ejb.setEnd_delay_time_value(res.getTime("end_delay_time_value"));
			} else {
				String msg = "JobStartInfo data is not found.";
				m_log.error("load() error : " + pk.toString() + " SQLException " + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("load() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			//コネクション、結果セット、プリペアドステートメントのクローズ
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (res != null) {
					res.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("load() error : " + pk.toString() + " SQLException " + e1.getMessage());
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("load() end : " + pk.toString());
	}

	/**
	 * UPDATE文を発行します。
	 * 引数で指定されたEntity Beanの内容でデータベースを更新します。
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobStartInfoDAO#store(com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoBean)
	 */
	@Override
	public void store(JobStartInfoBean ejb) throws EJBException {
		m_log.debug("store() start : " + ejb.getSession_id()
				+ ", jobunitId=" + ejb.getJobunit_id()
				+ ", jobId=" + ejb.getJob_id());

		Connection conn = null;
		PreparedStatement stmt = null;

		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQL文の定義
			StringBuilder sql = new StringBuilder();
			sql.append("UPDATE cc_job_start_info SET ");
			sql.append("condition_type = ?, ");
			sql.append("suspend = ?, ");
			sql.append("skip = ?, ");
			sql.append("skip_end_status = ?, ");
			sql.append("skip_end_value = ?, ");
			sql.append("unmatch_end_flg = ?, ");
			sql.append("unmatch_end_status = ?, ");
			sql.append("unmatch_end_value = ?, ");
			sql.append("calendar = ?, ");
			sql.append("calendar_id = ?, ");
			sql.append("calendar_end_value = ?, ");
			sql.append("start_delay = ?, ");
			sql.append("start_delay_session = ?, ");
			sql.append("start_delay_session_value = ?, ");
			sql.append("start_delay_time = ?, ");
			sql.append("start_delay_time_value = ?, ");
			sql.append("start_delay_condition_type = ?, ");
			sql.append("start_delay_notify = ?, ");
			sql.append("start_delay_notify_priority = ?, ");
			sql.append("start_delay_operation = ?, ");
			sql.append("start_delay_operation_type = ?, ");
			sql.append("start_delay_operation_end_value = ?, ");
			sql.append("end_delay = ?, ");
			sql.append("end_delay_session = ?, ");
			sql.append("end_delay_session_value = ?, ");
			sql.append("end_delay_job = ?, ");
			sql.append("end_delay_job_value = ?, ");
			sql.append("end_delay_time = ?, ");
			sql.append("end_delay_time_value = ?, ");
			sql.append("end_delay_condition_type = ?, ");
			sql.append("end_delay_notify = ?, ");
			sql.append("end_delay_notify_priority = ?, ");
			sql.append("end_delay_operation = ?, ");
			sql.append("end_delay_operation_type = ?, ");
			sql.append("end_delay_operation_end_value = ? ");
			sql.append("WHERE session_id = ? AND ");
			sql.append("job_id = ? ");
			sql.append("AND jobunit_id = ?");

			//SQL文のセット
			stmt = conn.prepareStatement(sql.toString());

			stmt.setInt(1, ejb.getCondition_type());
			stmt.setInt(2, ejb.getSuspend());
			stmt.setInt(3, ejb.getSkip());
			stmt.setInt(4, ejb.getSkip_end_status());
			stmt.setInt(5, ejb.getSkip_end_value());
			stmt.setInt(6, ejb.getUnmatch_end_flg());
			stmt.setInt(7, ejb.getUnmatch_end_status());
			stmt.setInt(8, ejb.getUnmatch_end_value());
			stmt.setInt(9, ejb.getCalendar());
			stmt.setString(10, ejb.getCalendar_id());
			stmt.setInt(11, ejb.getCalendar_end_value());
			stmt.setInt(12, ejb.getStart_delay());
			stmt.setInt(13, ejb.getStart_delay_session());
			stmt.setInt(14, ejb.getStart_delay_session_value());
			stmt.setInt(15, ejb.getStart_delay_time());
			stmt.setTime(16, ejb.getStart_delay_time_value());
			stmt.setInt(17, ejb.getStart_delay_condition_type());
			stmt.setInt(19, ejb.getStart_delay_notify());
			stmt.setInt(19, ejb.getStart_delay_notify_priority());
			stmt.setInt(20, ejb.getStart_delay_operation());
			stmt.setInt(21, ejb.getStart_delay_operation_type());
			stmt.setInt(21, ejb.getStart_delay_operation_end_value());
			stmt.setInt(22, ejb.getEnd_delay());
			stmt.setInt(23, ejb.getEnd_delay_session());
			stmt.setInt(24, ejb.getEnd_delay_session_value());
			stmt.setInt(25, ejb.getEnd_delay_job());
			stmt.setInt(27, ejb.getEnd_delay_job_value());
			stmt.setInt(28, ejb.getEnd_delay_time());
			stmt.setTime(29, ejb.getEnd_delay_time_value());
			stmt.setInt(30, ejb.getEnd_delay_condition_type());
			stmt.setInt(31, ejb.getEnd_delay_notify());
			stmt.setInt(32, ejb.getEnd_delay_notify_priority());
			stmt.setInt(33, ejb.getEnd_delay_operation());
			stmt.setInt(34, ejb.getEnd_delay_operation_type());
			stmt.setInt(35, ejb.getEnd_delay_operation_end_value());
			stmt.setString(36, ejb.getSession_id());
			stmt.setString(37, ejb.getJob_id());
			stmt.setString(38, ejb.getJobunit_id());

			int row = stmt.executeUpdate();

			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("store() error : " + ejb.getSession_id()
						+ ", jobunitId=" + ejb.getJobunit_id()
						+ ", jobId=" + ejb.getJob_id() + " SQLException" + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("store() error : " + ejb.getSession_id()
					+ ", jobunitId=" + ejb.getJobunit_id()
					+ ", jobId=" + ejb.getJob_id() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			// コネクション、結果セット、プリペアドステートメントのクローズ
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("store() error : " + ejb.getSession_id()
						+ ", jobunitId=" + ejb.getJobunit_id()
						+ ", jobId=" + ejb.getJob_id() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("store() end : " + ejb.getSession_id()
				+ ", jobunitId=" + ejb.getJobunit_id()
				+ ", jobId=" + ejb.getJob_id());
	}

	/**
	 * DELETE文を発行します。
	 * 引数で指定されたプライマリキーでデータベースから削除します。
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobStartInfoDAO#remove(com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoPK)
	 */
	@Override
	public void remove(JobStartInfoPK pk) throws RemoveException, EJBException {
		m_log.debug("remove() start : " + pk.toString());

		Connection conn = null;
		PreparedStatement stmt = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();

			//SQL文の定義
			String sql = "DELETE FROM cc_job_start_info WHERE session_id = ? AND job_id = ? AND jobunit_id = ?";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);

			stmt.setString(1, pk.getSession_id());
			stmt.setString(2, pk.getJob_id());
			stmt.setString(3, pk.getJobunit_id());

			int row = stmt.executeUpdate();

			if (row != 1 ) {
				String msg = "result row is not 1";
				m_log.error("remove() error : " + pk.toString() + " SQLException" + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("remove() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());

		} finally {
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("remove() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("remove() end : " + pk.toString());
	}

	/**
	 * INSERT文を発行します。
	 * 引数で指定されたEntity Beanの内容をデータベースに挿入し、プライマリキーを返します。
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobStartInfoDAO#create(com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoBean)
	 */
	@Override
	public JobStartInfoPK create(JobStartInfoBean ejb) throws CreateException, EJBException {
		m_log.debug("create() start : sessionId=" + ejb.getSession_id()
				+ ", jobunitId=" + ejb.getJobunit_id()
				+ ", jobId=" + ejb.getJob_id());

		Connection conn = null;
		PreparedStatement stmt = null;
		JobStartInfoPK pk;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQL文の定義
			StringBuilder sql = new StringBuilder();
			sql.append("INSERT INTO cc_job_start_info (");
			sql.append("session_id, ");
			sql.append("job_id, ");
			sql.append("condition_type, ");
			sql.append("suspend, ");
			sql.append("skip, ");
			sql.append("skip_end_status, ");
			sql.append("skip_end_value, ");
			sql.append("unmatch_end_flg, ");
			sql.append("unmatch_end_status, ");
			sql.append("unmatch_end_value, ");
			sql.append("calendar, ");
			sql.append("calendar_id, ");
			sql.append("calendar_end_value, ");
			sql.append("start_delay, ");
			sql.append("start_delay_session, ");
			sql.append("start_delay_session_value, ");
			sql.append("start_delay_time, ");
			sql.append("start_delay_time_value, ");
			sql.append("start_delay_condition_type, ");
			sql.append("start_delay_notify, ");
			sql.append("start_delay_notify_priority, ");
			sql.append("start_delay_operation, ");
			sql.append("start_delay_operation_type, ");
			sql.append("start_delay_operation_end_value, ");
			sql.append("end_delay, ");
			sql.append("end_delay_session, ");
			sql.append("end_delay_session_value, ");
			sql.append("end_delay_job, ");
			sql.append("end_delay_job_value, ");
			sql.append("end_delay_time, ");
			sql.append("end_delay_time_value, ");
			sql.append("end_delay_condition_type, ");
			sql.append("end_delay_notify, ");
			sql.append("end_delay_notify_priority, ");
			sql.append("end_delay_operation, ");
			sql.append("end_delay_operation_type, ");
			sql.append("end_delay_operation_end_value, ");
			sql.append("jobunit_id) ");
			sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");

			//SQL文のセット
			stmt = conn.prepareStatement(sql.toString());

			stmt.setString(1, ejb.getSession_id());
			stmt.setString(2, ejb.getJob_id());
			stmt.setInt(3, ejb.getCondition_type());
			stmt.setInt(4, ejb.getSuspend());
			stmt.setInt(5, ejb.getSkip());
			stmt.setInt(6, ejb.getSkip_end_status());
			stmt.setInt(7, ejb.getSkip_end_value());
			stmt.setInt(8, ejb.getUnmatch_end_flg());
			stmt.setInt(9, ejb.getUnmatch_end_status());
			stmt.setInt(10, ejb.getUnmatch_end_value());
			stmt.setInt(11, ejb.getCalendar());
			stmt.setString(12, ejb.getCalendar_id());
			stmt.setInt(13, ejb.getCalendar_end_value());
			stmt.setInt(14, ejb.getStart_delay());
			stmt.setInt(15, ejb.getStart_delay_session());
			stmt.setInt(16, ejb.getStart_delay_session_value());
			stmt.setInt(17, ejb.getStart_delay_time());
			stmt.setTime(18, ejb.getStart_delay_time_value());
			stmt.setInt(19, ejb.getStart_delay_condition_type());
			stmt.setInt(20, ejb.getStart_delay_notify());
			stmt.setInt(21, ejb.getStart_delay_notify_priority());
			stmt.setInt(22, ejb.getStart_delay_operation());
			stmt.setInt(23, ejb.getStart_delay_operation_type());
			stmt.setInt(24, ejb.getStart_delay_operation_end_value());
			stmt.setInt(25, ejb.getEnd_delay());
			stmt.setInt(26, ejb.getEnd_delay_session());
			stmt.setInt(27, ejb.getEnd_delay_session_value());
			stmt.setInt(28, ejb.getEnd_delay_job());
			stmt.setInt(29, ejb.getEnd_delay_job_value());
			stmt.setInt(30, ejb.getEnd_delay_time());
			stmt.setTime(31, ejb.getEnd_delay_time_value());
			stmt.setInt(32, ejb.getEnd_delay_condition_type());
			stmt.setInt(33, ejb.getEnd_delay_notify());
			stmt.setInt(34, ejb.getEnd_delay_notify_priority());
			stmt.setInt(35, ejb.getEnd_delay_operation());
			stmt.setInt(36, ejb.getEnd_delay_operation_type());
			stmt.setInt(37, ejb.getEnd_delay_operation_end_value());
			stmt.setString(38, ejb.getJobunit_id());

			int row =	stmt.executeUpdate();
			pk = new JobStartInfoPK(
					ejb.getSession_id(),
					ejb.getJobunit_id(),
					ejb.getJob_id());

			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("create() error : sessionId=" + ejb.getSession_id()
						+ ", jobunitId=" + ejb.getJobunit_id()
						+ ", jobId=" + ejb.getJob_id() + " SQLException");
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			if(e.getSQLState().equals("23505")){
				m_log.error("create() error : sessionId=" + ejb.getSession_id()
						+ ", jobunitId=" + ejb.getJobunit_id()
						+ ", jobId=" + ejb.getJob_id() + " SQLException" + "DuplicateKeyException ");
				throw new DuplicateKeyException(e.getMessage());
			}
			throw new CreateException(e.getMessage());
		}finally{
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("create() error : sessionId=" + ejb.getSession_id()
						+ ", jobunitId=" + ejb.getJobunit_id()
						+ ", jobId=" + ejb.getJob_id() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("create() end : sessionId=" + ejb.getSession_id()
				+ ", jobunitId=" + ejb.getJobunit_id()
				+ ", jobId=" + ejb.getJob_id());
		return pk;
	}

	/**
	 * 全件取得するSELECT文を発行します。
	 * 取得したデータのプライマリキーをコレクションに格納し返します。
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoBean#ejbFindAll()
	 * @see com.clustercontrol.jobmanagement.dao.JobStartInfoDAO#findAll()
	 */
	@Override
	public Collection findAll() throws FinderException {
		m_log.debug("findAll() start : ");

		ArrayList<JobStartInfoPK> ret = new ArrayList<JobStartInfoPK>();

		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQL文の定義
			String sql = "SELECT session_id, jobunit_id, job_id FROM cc_job_start_info";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			res = stmt.executeQuery();

			while(res.next()) {
				JobStartInfoPK pk= new JobStartInfoPK(
						res.getString("session_id"),
						res.getString("jobunit_id"),
						res.getString("job_id")
				);
				ret.add(pk);
			}

		} catch (SQLException e) {
			m_log.error("findAll() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findAll() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findAll() end : ");
		return ret;
	}

	/**
	 * 1件取得するSELECT文を発行します。
	 * 引数で指定されたプライマリキーで、データベースを検索します。
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoBean#ejbFindByPrimaryKey(com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoPK)
	 * @see com.clustercontrol.jobmanagement.dao.JobStartInfoDAO#findByPrimaryKey(com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoPK)
	 */
	@Override
	public JobStartInfoPK findByPrimaryKey(JobStartInfoPK pk) throws FinderException {
		m_log.debug("findByPrimaryKey() start : " + pk.toString());

		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();

			//SQL文の定義
			String sql = "SELECT session_id, jobunit_id, job_id FROM cc_job_start_info WHERE session_id = ? AND job_id = ? AND jobunit_id = ?";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);

			stmt.setString(1, pk.getSession_id());
			stmt.setString(2, pk.getJob_id());
			stmt.setString(3, pk.getJobunit_id());

			res = stmt.executeQuery();

			if (res.next()) {
				return pk;
			} else {
				String msg = "id " + pk.toString() + " not found.";
				throw new FinderException(msg);
			}
		} catch (SQLException e) {
			m_log.error("find() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("find() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("findByPrimaryKey() end : " + pk.toString());
		}
	}

	/**
	 * ジョブ待ち条件情報をジョブ待ち条件マスタから作成します。
	 * 
	 * @param sessionId セッションID
	 * @param jobunitId 所属ジョブユニットのジョブID
	 * @param jobs ジョブIDのコレクション
	 * @throws CreateException
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoBean#ejbHomeMakeSession(String, Collection)
	 */
	public void makeSession(String sessionId, String jobunitId, Collection jobs) throws CreateException{
		m_log.debug("makeSession() start : sessionId=" + sessionId + ", jobunitId=" + jobunitId);

		Connection conn=null;
		Connection connMaster = null;
		PreparedStatement stmt=null;
		PreparedStatement stmtMaster= null;
		String jobId = null;

		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			connMaster = ConnectionManager.getConnectionManager().getConnection();

			//SQL文の定義(INSERT)
			StringBuilder sql = new StringBuilder();
			sql.append("INSERT INTO cc_job_start_info (");
			sql.append("session_id, ");
			sql.append("job_id, ");
			sql.append("condition_type, ");
			sql.append("suspend, ");
			sql.append("skip, ");
			sql.append("skip_end_status, ");
			sql.append("skip_end_value, ");
			sql.append("unmatch_end_flg, ");
			sql.append("unmatch_end_status, ");
			sql.append("unmatch_end_value, ");
			sql.append("calendar, ");
			sql.append("calendar_id, ");
			sql.append("calendar_end_value, ");
			sql.append("start_delay, ");
			sql.append("start_delay_session, ");
			sql.append("start_delay_session_value, ");
			sql.append("start_delay_time, ");
			sql.append("start_delay_time_value, ");
			sql.append("start_delay_condition_type, ");
			sql.append("start_delay_notify, ");
			sql.append("start_delay_notify_priority, ");
			sql.append("start_delay_operation, ");
			sql.append("start_delay_operation_type, ");
			sql.append("start_delay_operation_end_value, ");
			sql.append("end_delay, ");
			sql.append("end_delay_session, ");
			sql.append("end_delay_session_value, ");
			sql.append("end_delay_job, ");
			sql.append("end_delay_job_value, ");
			sql.append("end_delay_time, ");
			sql.append("end_delay_time_value, ");
			sql.append("end_delay_condition_type, ");
			sql.append("end_delay_notify, ");
			sql.append("end_delay_notify_priority, ");
			sql.append("end_delay_operation, ");
			sql.append("end_delay_operation_type, ");
			sql.append("end_delay_operation_end_value, ");
			sql.append("jobunit_id) ");
			sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");

			//SQL文のセット(INSERT)
			stmt = conn.prepareStatement(sql.toString());
			stmt.setString(1,sessionId);
			stmt.setString(38, jobunitId);

			//SQL文の定義(マスタ検索)
			StringBuilder sqlMaster = new StringBuilder();
			sqlMaster.append("SELECT ");
			sqlMaster.append("cc_job_mst.job_type, ");
			sqlMaster.append("cc_job_start_mst.job_id,");
			sqlMaster.append("cc_job_start_mst.condition_type, ");
			sqlMaster.append("cc_job_start_mst.suspend, ");
			sqlMaster.append("cc_job_start_mst.skip,");
			sqlMaster.append("cc_job_start_mst.skip_end_status,");
			sqlMaster.append("cc_job_start_mst.skip_end_value, ");
			sqlMaster.append("cc_job_start_mst.unmatch_end_flg, ");
			sqlMaster.append("cc_job_start_mst.unmatch_end_status, ");
			sqlMaster.append("cc_job_start_mst.unmatch_end_value, ");
			sqlMaster.append("cc_job_start_mst.calendar, ");
			sqlMaster.append("cc_job_start_mst.calendar_id, ");
			sqlMaster.append("cc_job_start_mst.calendar_end_value, ");
			sqlMaster.append("cc_job_start_mst.start_delay, ");
			sqlMaster.append("cc_job_start_mst.start_delay_session, ");
			sqlMaster.append("cc_job_start_mst.start_delay_session_value, ");
			sqlMaster.append("cc_job_start_mst.start_delay_time, ");
			sqlMaster.append("cc_job_start_mst.start_delay_time_value, ");
			sqlMaster.append("cc_job_start_mst.start_delay_condition_type, ");
			sqlMaster.append("cc_job_start_mst.start_delay_notify, ");
			sqlMaster.append("cc_job_start_mst.start_delay_notify_priority, ");
			sqlMaster.append("cc_job_start_mst.start_delay_operation, ");
			sqlMaster.append("cc_job_start_mst.start_delay_operation_type, ");
			sqlMaster.append("cc_job_start_mst.start_delay_operation_end_value, ");
			sqlMaster.append("cc_job_start_mst.end_delay, ");
			sqlMaster.append("cc_job_start_mst.end_delay_session, ");
			sqlMaster.append("cc_job_start_mst.end_delay_session_value, ");
			sqlMaster.append("cc_job_start_mst.end_delay_job, ");
			sqlMaster.append("cc_job_start_mst.end_delay_job_value, ");
			sqlMaster.append("cc_job_start_mst.end_delay_time, ");
			sqlMaster.append("cc_job_start_mst.end_delay_time_value, ");
			sqlMaster.append("cc_job_start_mst.end_delay_condition_type, ");
			sqlMaster.append("cc_job_start_mst.end_delay_notify, ");
			sqlMaster.append("cc_job_start_mst.end_delay_notify_priority, ");
			sqlMaster.append("cc_job_start_mst.end_delay_operation, ");
			sqlMaster.append("cc_job_start_mst.end_delay_operation_type, ");
			sqlMaster.append("cc_job_start_mst.end_delay_operation_end_value ");
			sqlMaster.append("FROM cc_job_mst, cc_job_start_mst ");
			sqlMaster.append("WHERE ");
			sqlMaster.append("(cc_job_mst.job_id=cc_job_start_mst.job_id ");
			sqlMaster.append("AND cc_job_mst.jobunit_id=cc_job_start_mst.jobunit_id ");
			sqlMaster.append("AND cc_job_mst.job_id= ? ");
			sqlMaster.append("AND cc_job_mst.jobunit_id= ? ");
			sqlMaster.append(")");

			m_log.debug("makeSession() sqlMaster : sql=" + sqlMaster.toString());

			//SQL文のセット(マスタ検索)
			stmtMaster = connMaster.prepareStatement(sqlMaster.toString());

			Iterator it = jobs.iterator();
			while(it.hasNext()){
				//ジョブID取得
				Hashtable ht = (Hashtable)it.next();
				jobId = (String)ht.get("jobId");
				String parentJobId = (String)ht.get("parentJobId");

				//SQL文のセット(マスタ検索)
				stmtMaster.setString(1, jobId);
				stmtMaster.setString(2, jobunitId);

				//SQL実行(マスタ検索)
				ResultSet resMaster = stmtMaster.executeQuery();

				if (resMaster.next()) {
					//ジョブネット・ジョブ・ファイル転送ジョブの場合
					if(parentJobId.compareTo("TOP") !=0  &&
							(resMaster.getInt("job_type") == JobConstant.TYPE_JOBNET ||
									resMaster.getInt("job_type") == JobConstant.TYPE_JOB||
									resMaster.getInt("job_type") == JobConstant.TYPE_FILEJOB)){

						//SQL文のセット(INSERT)
						stmt.setString(2, resMaster.getString("job_id"));
						stmt.setInt(3, resMaster.getInt("condition_type"));
						stmt.setInt(4, resMaster.getInt("suspend"));
						stmt.setInt(5, resMaster.getInt("skip"));
						stmt.setInt(6, resMaster.getInt("skip_end_status"));
						stmt.setInt(7, resMaster.getInt("skip_end_value"));
						stmt.setInt(8, resMaster.getInt("unmatch_end_flg"));
						stmt.setInt(9, resMaster.getInt("unmatch_end_status"));
						stmt.setInt(10, resMaster.getInt("unmatch_end_value"));
						stmt.setInt(11, resMaster.getInt("calendar"));
						stmt.setString(12, resMaster.getString("calendar_id"));
						stmt.setInt(13, resMaster.getInt("calendar_end_value"));
						stmt.setInt(14, resMaster.getInt("start_delay"));
						stmt.setInt(15, resMaster.getInt("start_delay_session"));
						stmt.setInt(16, resMaster.getInt("start_delay_session_value"));
						stmt.setInt(17, resMaster.getInt("start_delay_time"));
						stmt.setTime(18, resMaster.getTime("start_delay_time_value"));
						stmt.setInt(19, resMaster.getInt("start_delay_condition_type"));
						stmt.setInt(20, resMaster.getInt("start_delay_notify"));
						stmt.setInt(21, resMaster.getInt("start_delay_notify_priority"));
						stmt.setInt(22, resMaster.getInt("start_delay_operation"));
						stmt.setInt(23, resMaster.getInt("start_delay_operation_type"));
						stmt.setInt(24, resMaster.getInt("start_delay_operation_end_value"));
						stmt.setInt(25, resMaster.getInt("end_delay"));
						stmt.setInt(26, resMaster.getInt("end_delay_session"));
						stmt.setInt(27, resMaster.getInt("end_delay_session_value"));
						stmt.setInt(28, resMaster.getInt("end_delay_job"));
						stmt.setInt(29, resMaster.getInt("end_delay_job_value"));
						stmt.setInt(30, resMaster.getInt("end_delay_time"));
						stmt.setTime(31, resMaster.getTime("end_delay_time_value"));
						stmt.setInt(32, resMaster.getInt("end_delay_condition_type"));
						stmt.setInt(33, resMaster.getInt("end_delay_notify"));
						stmt.setInt(34, resMaster.getInt("end_delay_notify_priority"));
						stmt.setInt(35, resMaster.getInt("end_delay_operation"));
						stmt.setInt(36, resMaster.getInt("end_delay_operation_type"));
						stmt.setInt(37, resMaster.getInt("end_delay_operation_end_value"));


						//INSERTを実行
						int row =	stmt.executeUpdate();
						if (row != 1) {
							String msg = "result row is not 1";
							m_log.error("makeSession() error : sessionId="
									+ sessionId + ", jobunitId=" + jobunitId
									+ ", " + resMaster.getString("job_id")
									+ " SQLException");
							throw new EJBException(msg);
						}
					}
				}
				resMaster.close();
			}
		} catch (SQLException e) {
			if(e.getSQLState().equals("23505")){
				m_log.error("makeSession() error : sessionId=" + sessionId
						+ ", jobunitId=" + jobunitId + ", " + jobId
						+ " SQLException" + "DuplicateKeyException ");
				throw new DuplicateKeyException(e.getMessage());
			}
			throw new CreateException(e.getMessage());
		} finally {
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
				if(stmtMaster != null){
					stmtMaster.close();
				}
				if(connMaster != null){
					connMaster.close();
				}
			} catch (SQLException e1) {
				m_log.error("makeSession() error : sessionId=" + sessionId
						+ ", jobunitId=" + jobunitId + ", " + jobId
						+ " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("makeSession() end : sessionId=" + sessionId
				+ ", jobunitId=" + jobunitId);
	}
}
