/*

Copyright (C) since 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.bean;

import java.io.Serializable;
import java.util.ArrayList;

import javax.xml.bind.annotation.XmlType;

/**
 * Hinemosの一括制御セッション情報を格納するクラス。<BR>
 * DTOクラスとしてマネージャ、クライアント間の通信で利用する。
 *
 */
@XmlType(namespace = "http://collectiverun.ws.clustercontrol.com")
public class SessionInfo implements Serializable {

	private static final long serialVersionUID = 6725448330301670200L;
	private String id = null;
	private Long startDate = null;
	private Long endDate = null;
	private String typeId = null;
	private String commandId = null;
	private String facilityId = null;
	private String scopeText = null;
	private Integer nodeCount = null;
	private Integer waitCount = null;
	private Integer runnningCount = null;
	private Integer endNormalCount = null;
	private Integer endWarningCount = null;
	private Integer endAbnormalCount = null;
	private Integer status = null;
	private ArrayList<SessionParameterInfo> params = new ArrayList<SessionParameterInfo>();


	public void setId(String id) {
		this.id = id;
	}
	public String getId() {
		return id;
	}
	public void setStartDate(Long startDate) {
		this.startDate = startDate;
	}
	public Long getStartDate() {
		return startDate;
	}
	public void setEndDate(Long endDate) {
		this.endDate = endDate;
	}
	public Long getEndDate() {
		return endDate;
	}
	public void setTypeId(String typeId) {
		this.typeId = typeId;
	}
	public String getTypeId() {
		return typeId;
	}
	public void setCommandId(String commandId) {
		this.commandId = commandId;
	}
	public String getCommandId() {
		return commandId;
	}
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}
	public String getFacilityId() {
		return facilityId;
	}
	public void setScopeText(String scopeText) {
		this.scopeText = scopeText;
	}
	public String getScopeText() {
		return scopeText;
	}
	public void setNodeCount(Integer nodeCount) {
		this.nodeCount = nodeCount;
	}
	public Integer getNodeCount() {
		return nodeCount;
	}
	public void setWaitCount(Integer waitCount) {
		this.waitCount = waitCount;
	}
	public Integer getWaitCount() {
		return waitCount;
	}
	public void setRunnningCount(Integer runnningCount) {
		this.runnningCount = runnningCount;
	}
	public Integer getRunnningCount() {
		return runnningCount;
	}
	public void setEndNormalCount(Integer endNormalCount) {
		this.endNormalCount = endNormalCount;
	}
	public Integer getEndNormalCount() {
		return endNormalCount;
	}
	public void setEndWarningCount(Integer endWarningCount) {
		this.endWarningCount = endWarningCount;
	}
	public Integer getEndWarningCount() {
		return endWarningCount;
	}
	public void setEndAbnormalCount(Integer endAbnormalCount) {
		this.endAbnormalCount = endAbnormalCount;
	}
	public Integer getEndAbnormalCount() {
		return endAbnormalCount;
	}
	public void setStatus(Integer status) {
		this.status = status;
	}
	public Integer getStatus() {
		return status;
	}
	public void setParams(ArrayList<SessionParameterInfo> params) {
		this.params = params;
	}
	public ArrayList<SessionParameterInfo> getParams() {
		return params;
	}
	public void addParam(SessionParameterInfo info) {
		this.params.add(info);
	}


}
