/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.monitor.bean;


/**
 * Quartz関連の定義を定数として格納するクラスです。
 *
 * @version 2.0.0
 * @since 1.0.0
 */
public class QuartzConstant {

	/**
	 *  ジョブのグループ。<BR>
	 *  ステータス情報の存続期間経過後の処理を呼び出すQuartzのジョブのグループ名です。
	 */
	public static final String GROUP_NAME_MON     = "MON";

	/**
	 *  Quartzから呼び出すJNDI名。<BR>
	 *  ステータス情報の存続期間経過後の処理を行うJNDI名です。
	 */
	public static final String JNDI_NAME_MON      = "MonitorController";

	/**
	 *  Quartzから呼び出すメソッド名。<BR>
	 *  ステータス情報の存続期間経過後の処理を行うメソッドの名前です。
	 */
	public static final String METHOD_NAME_STATUS = "manageStatus";

	public static final String QUARTZ_NAME = "DBMSScheduler";
}
