/*

Copyright (C) 2012 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.maintenance.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.Query;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.bean.PrivilegeConstant.ObjectPrivilegeMode;
import com.clustercontrol.commons.util.HinemosEntityManager;
import com.clustercontrol.commons.util.JpaPersistenceConfig;
import com.clustercontrol.commons.util.JpaTransactionManager;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.MaintenanceNotFound;
import com.clustercontrol.fault.ObjectPrivilege_InvalidRole;
import com.clustercontrol.maintenance.model.MaintenanceInfoEntity;
import com.clustercontrol.maintenance.model.MaintenanceTypeMstEntity;

public class QueryUtil {
	/** ログ出力のインスタンス */
	private static Log m_log = LogFactory.getLog( QueryUtil.class );

	public static MaintenanceTypeMstEntity getMaintenanceTypeMstPK(String typeId) throws MaintenanceNotFound {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		MaintenanceTypeMstEntity entity = em.find(MaintenanceTypeMstEntity.class, typeId);
		if (entity == null) {
			MaintenanceNotFound e = new MaintenanceNotFound("MaintenanceTypeMstEntity.findByPrimaryKey"
					+ ", typeId = " + typeId);
			m_log.info("getMaintenanceTypeMstPK() : "
					+ e.getClass().getSimpleName() + ", " + e.getMessage());
			throw e;
		}
		return entity;
	}

	public static List<MaintenanceTypeMstEntity> getAllMaintenanceTypeMst() {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		List<MaintenanceTypeMstEntity> list = em.createNamedQuery("MaintenanceTypeMstEntity.findAll"
				, MaintenanceTypeMstEntity.class).getResultList();
		return list;
	}

	public static MaintenanceInfoEntity getMaintenanceInfoPK(String maintenanceId) throws MaintenanceNotFound, InvalidRole {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		MaintenanceInfoEntity entity = null;
		try {
			entity = em.find(MaintenanceInfoEntity.class, maintenanceId);
			if (entity == null) {
				MaintenanceNotFound e = new MaintenanceNotFound("MaintenanceInfoEntity.findByPrimaryKey"
						+ ", maintenanceId = " + maintenanceId);
				m_log.info("getMaintenanceInfoPK() : "
						+ e.getClass().getSimpleName() + ", " + e.getMessage());
				throw e;
			}
		} catch (ObjectPrivilege_InvalidRole e) {
			m_log.info("getMaintenanceInfoPK() : "
					+ e.getClass().getSimpleName() + ", " + e.getMessage());
			throw new InvalidRole(e.getMessage(), e);
		}
		return entity;
	}

	public static List<MaintenanceInfoEntity> getAllMaintenanceInfoOrderByMaintenanceId() {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		List<MaintenanceInfoEntity> list = em.createNamedQuery("MaintenanceInfoEntity.findAllOrderByMaintenanceId"
				,MaintenanceInfoEntity.class).getResultList();
		return list;
	}

	public static List<MaintenanceInfoEntity> getMaintenanceInfoFindByCalendarId_NONE(String calendarId) {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		List<MaintenanceInfoEntity> list
		= ((HinemosEntityManager)em).createNamedQuery("MaintenanceInfoEntity.findByCalendarId"
				,MaintenanceInfoEntity.class, ObjectPrivilegeMode.NONE)
				.setParameter("calendarId", calendarId)
				.getResultList();
		return list;
	}

	public static int deleteCalculatedDataByDateTime(Timestamp dateTime, int timeout) {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		Query query = em.createNamedQuery("CalculatedDataEntity.deleteByDateTime")
				.setParameter("dateTime", dateTime);
		if (timeout > 0) {
			query = query.setHint(JpaPersistenceConfig.JPA_PARAM_QUERY_TIMEOUT, timeout * 1000);
		}
		return query.executeUpdate();
	}

	public static int deleteCalculatedDataByDateTimeCollectorid(Timestamp dateTime, int timeout) {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		Query query = em.createNamedQuery("CalculatedDataEntity.deleteByDateTimeCollectorid")
				.setParameter("dateTime", dateTime);
		if (timeout > 0) {
			query = query.setHint(JpaPersistenceConfig.JPA_PARAM_QUERY_TIMEOUT, timeout * 1000);
		}
		return query.executeUpdate();
	}

	public static int deleteVmOperationDetailByStartDate(Timestamp startDate, int timeout) {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		Query query = em.createNamedQuery("VmOperationDetailEntity.deleteByStartDate")
				.setParameter("startDate", startDate);
		if (timeout > 0) {
			query = query.setHint(JpaPersistenceConfig.JPA_PARAM_QUERY_TIMEOUT, timeout * 1000);
		}
		return query.executeUpdate();
	}

	public static int deleteVmOperationDetailByStartDateStatus(Timestamp startDate, int timeout) {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		Query query = em.createNamedQuery("VmOperationDetailEntity.deleteByStartDateStatus")
				.setParameter("startDate", startDate);
		if (timeout > 0) {
			query = query.setHint(JpaPersistenceConfig.JPA_PARAM_QUERY_TIMEOUT, timeout * 1000);
		}
		return query.executeUpdate();
	}

	public static int deleteEventLogByGenerationDate(Timestamp generationDate, int timeout) {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		Query query = em.createNamedQuery("EventLogEntity.deleteByGenerationDate")
				.setParameter("generationDate", generationDate);
		if (timeout > 0) {
			query = query.setHint(JpaPersistenceConfig.JPA_PARAM_QUERY_TIMEOUT, timeout * 1000);
		}
		return query.executeUpdate();
	}

	public static int deleteEventLogByGenerationDateConfigFlg(Timestamp generationDate, int timeout) {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		Query query = em.createNamedQuery("EventLogEntity.deleteByGenerationDateConfigFlg")
				.setParameter("generationDate", generationDate);
		if (timeout > 0) {
			query = query.setHint(JpaPersistenceConfig.JPA_PARAM_QUERY_TIMEOUT, timeout * 1000);
		}
		return query.executeUpdate();
	}

	public static int deleteCrunSessionByStartDate(Timestamp startDate, int timeout) {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		Query query = em.createNamedQuery("CrunSessionEntity.deleteByStartDate")
				.setParameter("startDate", startDate);
		if (timeout > 0) {
			query = query.setHint(JpaPersistenceConfig.JPA_PARAM_QUERY_TIMEOUT, timeout * 1000);
		}
		return query.executeUpdate();
	}

	public static int deleteCrunSessionByStartDateStatusEnd(Timestamp startDate, int timeout) {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		Query query = em.createNamedQuery("CrunSessionEntity.deleteByStartDateStatusEnd")
				.setParameter("startDate", startDate);
		if (timeout > 0) {
			query = query.setHint(JpaPersistenceConfig.JPA_PARAM_QUERY_TIMEOUT, timeout * 1000);
		}
		return query.executeUpdate();
	}

	public static int createJobCompletedSessionsTable() {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		int ret = em.createNamedQuery("JobCompletedSessionsEntity.createTable").executeUpdate();
		return ret;
	}

	public static int insertJobCompletedSessionsJobSessionJob(Timestamp startDate) {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		int ret = em.createNamedQuery("JobCompletedSessionsEntity.insertJobSessionJob")
				.setParameter(1, startDate)
				.executeUpdate();
		return ret;
	}

	public static int dropJobCompletedSessionsTable() {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		int ret = em.createNamedQuery("JobCompletedSessionsEntity.dropTable").executeUpdate();
		return ret;
	}

	public static int insertJobCompletedSessionsJobSessionJobByStatus(Timestamp startDate) {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		int ret = em.createNamedQuery("JobCompletedSessionsEntity.insertJobSessionJobByStatus")
				.setParameter(1, startDate)
				.executeUpdate();
		return ret;
	}

	public static int deleteJobSessionByCompletedSessions() {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		int ret = em.createNamedQuery("JobSessionEntity.deleteByJobCompletedSessions")
				.executeUpdate();
		return ret;
	}

	public static int deleteNotifyRelationInfoByCompletedSessions() {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		int ret = em.createNamedQuery("NotifyRelationInfoEntity.deleteByJobCompletedSessions")
				.executeUpdate();
		return ret;
	}

	public static int deleteMonitorStatusByCompletedSessions() {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		int ret = em.createNamedQuery("MonitorStatusEntity.deleteByJobCompletedSessions")
				.executeUpdate();
		return ret;
	}

	public static int deleteNotifyHistoryByCompletedSessions() {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		int ret = em.createNamedQuery("NotifyHistoryEntity.deleteByJobCompletedSessions")
				.executeUpdate();
		return ret;
	}

	public static List<String> selectCompletedSession() {
		List<String> sessionList = new JpaTransactionManager().getEntityManager()
				.createNamedQuery("JobCompletedSession.selectSessionId")
				.getResultList();
		return sessionList;
	}
}
