package com.clustercontrol.repository.model;

import java.io.Serializable;
import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;

import java.util.Iterator;
import java.util.List;


/**
 * The persistent class for the cc_cfg_node database table.
 * 
 */
@Entity
@Table(name="cc_cfg_node")
@Cacheable(true)
public class NodeEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private String facilityId;
	private String administrator			= "";
	private String characterSet				= "";
	private String cloudNodeType			= "";
	private String cloudService				= "";
	private String cloudAccountResouce		= "";
	private String cloudResourceType		= "";
	private String cloudResourceId			= "";
	private String cloudRegion				= "";
	private String cloudZone				= "";
	private String contact					= "";
	private String hardwareType				= "";
	private String ipAddressV4				= "";
	private String ipAddressV6				= "";
	private Integer ipAddressVersion		= -1;
	private String ipmiIpAddress			= "";
	private String ipmiLevel				= "";
	private Integer ipmiPort				= 0;
	private String ipmiProtocol				= "RMCP+";
	private Integer ipmiRetryCount			= 3;
	private Integer ipmiTimeout				= 5000;
	private String ipmiUser					= "root";
	private String ipmiUserPassword			= "";
	private Integer jobPriority				= 16;
	private Integer jobMultiplicity			= 0;
	private String nodeName					= "";
	private String openflowCtrlIpAddress	= "";
	private String openflowDataPathId		= "";
	private String osName					= "";
	private String osRelease				= "";
	private String osVersion				= "";
	private String platformFamily			= "";
	private String snmpCommunity			= "public";
	private Integer snmpPort				= 161;
	private Integer snmpRetryCount			= 3;
	private Integer snmpTimeout				= 5000;
	private String snmpVersion				= "2c";
	private String subPlatformFamily		= "";
	private String vmId						= "";
	private String vmManagementNode			= "";
	private String vmName					= "";
	private String vmNodeType				= "";
	private String vmProtocol				= "";
	private String vmUser					= "";
	private String vmUserPassword			= "";
	private String vnetHostNode				= "";
	private String vnetSwitchType			= "";
	private Integer wbemPort				= 5988;
	private String wbemProtocol				= "http";
	private Integer wbemRetryCount			= 3;
	private Integer wbemTimeout				= 5000;
	private String wbemUser					= "root";
	private String wbemUserPassword			= "";
	private Integer winrmPort				= 5985;
	private String winrmProtocol			= "http";
	private Integer winrmRetryCount			= 3;
	private Integer winrmTimeout			= 5000;
	private String winrmUser				= "Administrator";
	private String winrmUserPassword		= "";
	private String winrmVersion				= "";
	private Integer agentAwakePort			= 24005;
	private List<NodeCpuEntity> nodeCpuEntities;
	private List<NodeDeviceEntity> nodeDeviceEntities;
	private List<NodeDiskEntity> nodeDiskEntities;
	private FacilityEntity facilityEntity;
	private List<NodeFilesystemEntity> nodeFilesystemEntities;
	private List<NodeHostnameEntity> nodeHostnameEntities;
	private List<NodeMemoryEntity> nodeMemoryEntities;
	private List<NodeNetworkInterfaceEntity> nodeNetworkInterfaceEntities;
	private List<NodeNoteEntity> nodeNoteEntities;
	private List<NodeVariableEntity> nodeVariableEntities;

	@Deprecated
	public NodeEntity() {
	}

	public NodeEntity(FacilityEntity facilityEntity) {
		this.setFacilityId(facilityEntity.getFacilityId());
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
		this.relateToFacilityEntity(facilityEntity);
	}


	@Id
	@Column(name="facility_id")
	public String getFacilityId() {
		return this.facilityId;
	}

	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}


	public String getAdministrator() {
		return this.administrator;
	}

	public void setAdministrator(String administrator) {
		this.administrator = administrator;
	}


	@Column(name="character_set")
	public String getCharacterSet() {
		return this.characterSet;
	}

	public void setCharacterSet(String characterSet) {
		this.characterSet = characterSet;
	}


	@Column(name="cloud_node_type")
	public String getCloudNodeType() {
		return this.cloudNodeType;
	}

	public void setCloudNodeType(String cloudNodeType) {
		this.cloudNodeType = cloudNodeType;
	}


	@Column(name="cloud_service")
	public String getCloudService() {
		return this.cloudService;
	}

	public void setCloudService(String cloudService) {
		this.cloudService = cloudService;
	}


	@Column(name="cloud_account_resource")
	public String getCloudAccountResouce() {
		return this.cloudAccountResouce;
	}

	public void setCloudAccountResouce(String cloudAccountResouce) {
		this.cloudAccountResouce = cloudAccountResouce;
	}


	@Column(name="cloud_resource_type")
	public String getCloudResourceType() {
		return this.cloudResourceType;
	}

	public void setCloudResourceType(String cloudResourceType) {
		this.cloudResourceType = cloudResourceType;
	}


	@Column(name="cloud_resource_id")
	public String getCloudResourceId() {
		return this.cloudResourceId;
	}

	public void setCloudResourceId(String cloudResourceId) {
		this.cloudResourceId = cloudResourceId;
	}


	@Column(name="cloud_region")
	public String getCloudRegion() {
		return this.cloudRegion;
	}

	public void setCloudRegion(String cloudRegion) {
		this.cloudRegion = cloudRegion;
	}


	@Column(name="cloud_zone")
	public String getCloudZone() {
		return this.cloudZone;
	}

	public void setCloudZone(String cloudZone) {
		this.cloudZone = cloudZone;
	}


	public String getContact() {
		return this.contact;
	}

	public void setContact(String contact) {
		this.contact = contact;
	}


	@Column(name="hardware_type")
	public String getHardwareType() {
		return this.hardwareType;
	}

	public void setHardwareType(String hardwareType) {
		this.hardwareType = hardwareType;
	}

	@Column(name="ip_address_v4")
	public String getIpAddressV4() {
		return this.ipAddressV4;
	}

	public void setIpAddressV4(String ipAddressV4) {
		this.ipAddressV4 = ipAddressV4;
	}


	@Column(name="ip_address_v6")
	public String getIpAddressV6() {
		return this.ipAddressV6;
	}

	public void setIpAddressV6(String ipAddressV6) {
		this.ipAddressV6 = ipAddressV6;
	}


	@Column(name="ip_address_version")
	public Integer getIpAddressVersion() {
		return this.ipAddressVersion;
	}

	public void setIpAddressVersion(Integer ipAddressVersion) {
		this.ipAddressVersion = ipAddressVersion;
	}


	@Column(name="ipmi_ip_address")
	public String getIpmiIpAddress() {
		return this.ipmiIpAddress;
	}

	public void setIpmiIpAddress(String ipmiIpAddress) {
		this.ipmiIpAddress = ipmiIpAddress;
	}


	@Column(name="ipmi_level")
	public String getIpmiLevel() {
		return this.ipmiLevel;
	}

	public void setIpmiLevel(String ipmiLevel) {
		this.ipmiLevel = ipmiLevel;
	}


	@Column(name="ipmi_port")
	public Integer getIpmiPort() {
		return this.ipmiPort;
	}

	public void setIpmiPort(Integer ipmiPort) {
		this.ipmiPort = ipmiPort;
	}


	@Column(name="ipmi_protocol")
	public String getIpmiProtocol() {
		return this.ipmiProtocol;
	}

	public void setIpmiProtocol(String ipmiProtocol) {
		this.ipmiProtocol = ipmiProtocol;
	}


	@Column(name="ipmi_retry_count")
	public Integer getIpmiRetryCount() {
		return this.ipmiRetryCount;
	}

	public void setIpmiRetryCount(Integer ipmiRetryCount) {
		this.ipmiRetryCount = ipmiRetryCount;
	}


	@Column(name="ipmi_timeout")
	public Integer getIpmiTimeout() {
		return this.ipmiTimeout;
	}

	public void setIpmiTimeout(Integer ipmiTimeout) {
		this.ipmiTimeout = ipmiTimeout;
	}


	@Column(name="job_priority")
	public Integer getJobPriority() {
		return this.jobPriority;
	}

	public void setJobPriority(Integer jobPriority) {
		this.jobPriority = jobPriority;
	}


	@Column(name="job_multiplicity")
	public Integer getJobMultiplicity() {
		return this.jobMultiplicity;
	}

	public void setJobMultiplicity(Integer jobMultiplicity) {
		this.jobMultiplicity = jobMultiplicity;
	}


	@Column(name="ipmi_user")
	public String getIpmiUser() {
		return this.ipmiUser;
	}

	public void setIpmiUser(String ipmiUser) {
		this.ipmiUser = ipmiUser;
	}


	@Column(name="ipmi_user_password")
	public String getIpmiUserPassword() {
		return this.ipmiUserPassword;
	}

	public void setIpmiUserPassword(String ipmiUserPassword) {
		this.ipmiUserPassword = ipmiUserPassword;
	}


	@Column(name="node_name")
	public String getNodeName() {
		return this.nodeName;
	}

	public void setNodeName(String nodeName) {
		this.nodeName = nodeName;
	}


	@Column(name="openflow_ctrl_ip_address")
	public String getOpenflowCtrlIpAddress() {
		return this.openflowCtrlIpAddress;
	}

	public void setOpenflowCtrlIpAddress(String openflowCtrlIpAddress) {
		this.openflowCtrlIpAddress = openflowCtrlIpAddress;
	}


	@Column(name="openflow_data_path_id")
	public String getOpenflowDataPathId() {
		return this.openflowDataPathId;
	}

	public void setOpenflowDataPathId(String openflowDataPathId) {
		this.openflowDataPathId = openflowDataPathId;
	}


	@Column(name="os_name")
	public String getOsName() {
		return this.osName;
	}

	public void setOsName(String osName) {
		this.osName = osName;
	}


	@Column(name="os_release")
	public String getOsRelease() {
		return this.osRelease;
	}

	public void setOsRelease(String osRelease) {
		this.osRelease = osRelease;
	}


	@Column(name="os_version")
	public String getOsVersion() {
		return this.osVersion;
	}

	public void setOsVersion(String osVersion) {
		this.osVersion = osVersion;
	}


	@Column(name="platform_family")
	public String getPlatformFamily() {
		return this.platformFamily;
	}

	public void setPlatformFamily(String platformFamily) {
		this.platformFamily = platformFamily;
	}


	@Column(name="snmp_community")
	public String getSnmpCommunity() {
		return this.snmpCommunity;
	}

	public void setSnmpCommunity(String snmpCommunity) {
		this.snmpCommunity = snmpCommunity;
	}


	@Column(name="snmp_port")
	public Integer getSnmpPort() {
		return this.snmpPort;
	}

	public void setSnmpPort(Integer snmpPort) {
		this.snmpPort = snmpPort;
	}


	@Column(name="snmp_retry_count")
	public Integer getSnmpRetryCount() {
		return this.snmpRetryCount;
	}

	public void setSnmpRetryCount(Integer snmpRetryCount) {
		this.snmpRetryCount = snmpRetryCount;
	}


	@Column(name="snmp_timeout")
	public Integer getSnmpTimeout() {
		return this.snmpTimeout;
	}

	public void setSnmpTimeout(Integer snmpTimeout) {
		this.snmpTimeout = snmpTimeout;
	}


	@Column(name="snmp_version")
	public String getSnmpVersion() {
		return this.snmpVersion;
	}

	public void setSnmpVersion(String snmpVersion) {
		this.snmpVersion = snmpVersion;
	}


	@Column(name="sub_platform_family")
	public String getSubPlatformFamily() {
		return this.subPlatformFamily;
	}

	public void setSubPlatformFamily(String subPlatformFamily) {
		this.subPlatformFamily = subPlatformFamily;
	}


	@Column(name="vm_id")
	public String getVmId() {
		return this.vmId;
	}

	public void setVmId(String vmId) {
		this.vmId = vmId;
	}


	@Column(name="vm_management_node")
	public String getVmManagementNode() {
		return this.vmManagementNode;
	}

	public void setVmManagementNode(String vmManagementNode) {
		this.vmManagementNode = vmManagementNode;
	}


	@Column(name="vm_name")
	public String getVmName() {
		return this.vmName;
	}

	public void setVmName(String vmName) {
		this.vmName = vmName;
	}


	@Column(name="vm_node_type")
	public String getVmNodeType() {
		return this.vmNodeType;
	}

	public void setVmNodeType(String vmNodeType) {
		this.vmNodeType = vmNodeType;
	}


	@Column(name="vm_protocol")
	public String getVmProtocol() {
		return this.vmProtocol;
	}

	public void setVmProtocol(String vmProtocol) {
		this.vmProtocol = vmProtocol;
	}


	@Column(name="vm_user")
	public String getVmUser() {
		return this.vmUser;
	}

	public void setVmUser(String vmUser) {
		this.vmUser = vmUser;
	}


	@Column(name="vm_user_password")
	public String getVmUserPassword() {
		return this.vmUserPassword;
	}

	public void setVmUserPassword(String vmUserPassword) {
		this.vmUserPassword = vmUserPassword;
	}


	@Column(name="vnet_host_node")
	public String getVnetHostNode() {
		return this.vnetHostNode;
	}

	public void setVnetHostNode(String vnetHostNode) {
		this.vnetHostNode = vnetHostNode;
	}


	@Column(name="vnet_switch_type")
	public String getVnetSwitchType() {
		return this.vnetSwitchType;
	}

	public void setVnetSwitchType(String vnetSwitchType) {
		this.vnetSwitchType = vnetSwitchType;
	}


	@Column(name="wbem_port")
	public Integer getWbemPort() {
		return this.wbemPort;
	}

	public void setWbemPort(Integer wbemPort) {
		this.wbemPort = wbemPort;
	}


	@Column(name="wbem_protocol")
	public String getWbemProtocol() {
		return this.wbemProtocol;
	}

	public void setWbemProtocol(String wbemProtocol) {
		this.wbemProtocol = wbemProtocol;
	}


	@Column(name="wbem_retry_count")
	public Integer getWbemRetryCount() {
		return this.wbemRetryCount;
	}

	public void setWbemRetryCount(Integer wbemRetryCount) {
		this.wbemRetryCount = wbemRetryCount;
	}


	@Column(name="wbem_timeout")
	public Integer getWbemTimeout() {
		return this.wbemTimeout;
	}

	public void setWbemTimeout(Integer wbemTimeout) {
		this.wbemTimeout = wbemTimeout;
	}


	@Column(name="wbem_user")
	public String getWbemUser() {
		return this.wbemUser;
	}

	public void setWbemUser(String wbemUser) {
		this.wbemUser = wbemUser;
	}


	@Column(name="wbem_user_password")
	public String getWbemUserPassword() {
		return this.wbemUserPassword;
	}

	public void setWbemUserPassword(String wbemUserPassword) {
		this.wbemUserPassword = wbemUserPassword;
	}


	@Column(name="winrm_port")
	public Integer getWinrmPort() {
		return this.winrmPort;
	}

	public void setWinrmPort(Integer winrmPort) {
		this.winrmPort = winrmPort;
	}


	@Column(name="winrm_protocol")
	public String getWinrmProtocol() {
		return this.winrmProtocol;
	}

	public void setWinrmProtocol(String winrmProtocol) {
		this.winrmProtocol = winrmProtocol;
	}


	@Column(name="winrm_retry_count")
	public Integer getWinrmRetryCount() {
		return this.winrmRetryCount;
	}

	public void setWinrmRetryCount(Integer winrmRetryCount) {
		this.winrmRetryCount = winrmRetryCount;
	}


	@Column(name="winrm_timeout")
	public Integer getWinrmTimeout() {
		return this.winrmTimeout;
	}

	public void setWinrmTimeout(Integer winrmTimeout) {
		this.winrmTimeout = winrmTimeout;
	}


	@Column(name="winrm_user")
	public String getWinrmUser() {
		return this.winrmUser;
	}

	public void setWinrmUser(String winrmUser) {
		this.winrmUser = winrmUser;
	}


	@Column(name="winrm_user_password")
	public String getWinrmUserPassword() {
		return this.winrmUserPassword;
	}

	public void setWinrmUserPassword(String winrmUserPassword) {
		this.winrmUserPassword = winrmUserPassword;
	}


	@Column(name="winrm_version")
	public String getWinrmVersion() {
		return this.winrmVersion;
	}

	public void setWinrmVersion(String winrmVersion) {
		this.winrmVersion = winrmVersion;
	}

	@Column(name="agent_awake_port")
	public Integer getAgentAwakePort() {
		return this.agentAwakePort;
	}

	public void setAgentAwakePort(Integer agentAwakePort) {
		this.agentAwakePort = agentAwakePort;
	}

	//bi-directional many-to-one association to NodeCpuEntity
	@OneToMany(mappedBy="nodeEntity", cascade=CascadeType.ALL, orphanRemoval=true, fetch=FetchType.LAZY)
	public List<NodeCpuEntity> getNodeCpuEntities() {
		return this.nodeCpuEntities;
	}

	public void setNodeCpuEntities(List<NodeCpuEntity> nodeCpuEntities) {
		this.nodeCpuEntities = nodeCpuEntities;
	}


	//bi-directional many-to-one association to NodeDeviceEntity
	@OneToMany(mappedBy="nodeEntity", cascade=CascadeType.ALL, orphanRemoval=true, fetch=FetchType.LAZY)
	public List<NodeDeviceEntity> getNodeDeviceEntities() {
		return this.nodeDeviceEntities;
	}

	public void setNodeDeviceEntities(List<NodeDeviceEntity> nodeDeviceEntities) {
		this.nodeDeviceEntities = nodeDeviceEntities;
	}


	//bi-directional many-to-one association to NodeDiskEntity
	@OneToMany(mappedBy="nodeEntity", cascade=CascadeType.ALL, orphanRemoval=true, fetch=FetchType.LAZY)
	public List<NodeDiskEntity> getNodeDiskEntities() {
		return this.nodeDiskEntities;
	}

	public void setNodeDiskEntities(List<NodeDiskEntity> nodeDiskEntities) {
		this.nodeDiskEntities = nodeDiskEntities;
	}


	//bi-directional one-to-one association to FacilityEntity
	@OneToOne(fetch=FetchType.LAZY, optional=false)
	@PrimaryKeyJoinColumn(name="facility_id")
	public FacilityEntity getFacilityEntity() {
		return this.facilityEntity;
	}

	@Deprecated
	public void setFacilityEntity(FacilityEntity facilityEntity) {
		this.facilityEntity = facilityEntity;
	}

	/**
	 * NodeEntityオブジェクト参照設定<BR>
	 * 
	 * NodeEntity設定時はSetterに代わりこちらを使用すること。
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void relateToFacilityEntity(FacilityEntity facilityEntity) {
		this.setFacilityEntity(facilityEntity);
		if (facilityEntity != null) {
			facilityEntity.setNodeEntity(this);
		}
	}


	//bi-directional many-to-one association to NodeFilesystemEntity
	@OneToMany(mappedBy="nodeEntity", cascade=CascadeType.ALL, orphanRemoval=true, fetch=FetchType.LAZY)
	public List<NodeFilesystemEntity> getNodeFilesystemEntities() {
		return this.nodeFilesystemEntities;
	}

	public void setNodeFilesystemEntities(List<NodeFilesystemEntity> nodeFilesystemEntities) {
		this.nodeFilesystemEntities = nodeFilesystemEntities;
	}


	//bi-directional many-to-one association to NodeHostnameEntity
	@OneToMany(mappedBy="nodeEntity", cascade=CascadeType.ALL, orphanRemoval=true, fetch=FetchType.LAZY)
	public List<NodeHostnameEntity> getNodeHostnameEntities() {
		return this.nodeHostnameEntities;
	}

	public void setNodeHostnameEntities(List<NodeHostnameEntity> nodeHostnameEntities) {
		this.nodeHostnameEntities = nodeHostnameEntities;
	}


	//bi-directional many-to-one association to NodeMemoryEntity
	@OneToMany(mappedBy="nodeEntity", cascade=CascadeType.ALL, orphanRemoval=true, fetch=FetchType.LAZY)
	public List<NodeMemoryEntity> getNodeMemoryEntities() {
		return this.nodeMemoryEntities;
	}

	public void setNodeMemoryEntities(List<NodeMemoryEntity> nodeMemoryEntities) {
		this.nodeMemoryEntities = nodeMemoryEntities;
	}


	//bi-directional many-to-one association to NodeNetworkInterfaceEntity
	@OneToMany(mappedBy="nodeEntity", cascade=CascadeType.ALL, orphanRemoval=true, fetch=FetchType.LAZY)
	public List<NodeNetworkInterfaceEntity> getNodeNetworkInterfaceEntities() {
		return this.nodeNetworkInterfaceEntities;
	}

	public void setNodeNetworkInterfaceEntities(List<NodeNetworkInterfaceEntity> nodeNetworkInterfaceEntities) {
		this.nodeNetworkInterfaceEntities = nodeNetworkInterfaceEntities;
	}


	//bi-directional many-to-one association to NodeNoteEntity
	@OneToMany(mappedBy="nodeEntity", cascade=CascadeType.ALL, orphanRemoval=true, fetch=FetchType.LAZY)
	public List<NodeNoteEntity> getNodeNoteEntities() {
		return this.nodeNoteEntities;
	}

	public void setNodeNoteEntities(List<NodeNoteEntity> nodeNoteEntities) {
		this.nodeNoteEntities = nodeNoteEntities;
	}


	//bi-directional many-to-one association to NodeVariableEntity
	@OneToMany(mappedBy="nodeEntity", cascade=CascadeType.ALL, orphanRemoval=true, fetch=FetchType.LAZY)
	public List<NodeVariableEntity> getNodeVariableEntities() {
		return this.nodeVariableEntities;
	}

	public void setNodeVariableEntities(List<NodeVariableEntity> nodeVariableEntities) {
		this.nodeVariableEntities = nodeVariableEntities;
	}

	/**
	 * 削除前処理<BR>
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void unchain() {

		// FacilityEntity
		if (this.facilityEntity != null) {
			this.facilityEntity.setNodeEntity(null);
		}
	}
	/**
	 * NodeCpuEntity削除<BR>
	 * 
	 * 指定されたPK以外の子Entityを削除する。
	 * 
	 */
	public void deleteNodeCpuEntities(List<NodeCpuEntityPK> notDelPkList) {
		if (notDelPkList == null || notDelPkList.size() == 0) {
			this.setNodeCpuEntities(null);
		} else {
			List<NodeCpuEntity> list = this.getNodeCpuEntities();
			Iterator<NodeCpuEntity> iter = list.iterator();
			while(iter.hasNext()) {
				NodeCpuEntity entity = iter.next();
				if (!notDelPkList.contains(entity.getId())) {
					iter.remove();
				}
			}
		}
	}

	/**
	 * NodeDeviceEntity削除<BR>
	 * 
	 * 指定されたPK以外の子Entityを削除する。
	 * 
	 */
	public void deleteNodeDeviceEntities(List<NodeDeviceEntityPK> notDelPkList) {
		if (notDelPkList == null || notDelPkList.size() == 0) {
			this.setNodeDeviceEntities(null);
		} else {
			List<NodeDeviceEntity> list = this.getNodeDeviceEntities();
			Iterator<NodeDeviceEntity> iter = list.iterator();
			while(iter.hasNext()) {
				NodeDeviceEntity entity = iter.next();
				if (!notDelPkList.contains(entity.getId())) {
					iter.remove();
				}
			}
		}
	}

	/**
	 * NodeDiskEntity削除<BR>
	 * 
	 * 指定されたPK以外の子Entityを削除する。
	 * 
	 */
	public void deleteNodeDiskEntities(List<NodeDiskEntityPK> notDelPkList) {
		if (notDelPkList == null || notDelPkList.size() == 0) {
			this.setNodeDiskEntities(null);
		} else {
			List<NodeDiskEntity> list = this.getNodeDiskEntities();
			Iterator<NodeDiskEntity> iter = list.iterator();
			while(iter.hasNext()) {
				NodeDiskEntity entity = iter.next();
				if (!notDelPkList.contains(entity.getId())) {
					iter.remove();
				}
			}
		}
	}

	/**
	 * NodeFilesystemEntity削除<BR>
	 * 
	 * 指定されたPK以外の子Entityを削除する。
	 * 
	 */
	public void deleteNodeFilesystemEntities(List<NodeFilesystemEntityPK> notDelPkList) {
		if (notDelPkList == null || notDelPkList.size() == 0) {
			this.setNodeFilesystemEntities(null);
		} else {
			List<NodeFilesystemEntity> list = this.getNodeFilesystemEntities();
			Iterator<NodeFilesystemEntity> iter = list.iterator();
			while(iter.hasNext()) {
				NodeFilesystemEntity entity = iter.next();
				if (!notDelPkList.contains(entity.getId())) {
					iter.remove();
				}
			}
		}
	}

	/**
	 * NodeHostnameEntity削除<BR>
	 * 
	 * 指定されたPK以外の子Entityを削除する。
	 * 
	 */
	public void deleteNodeHostnameEntities(List<NodeHostnameEntityPK> notDelPkList) {
		if (notDelPkList == null || notDelPkList.size() == 0) {
			this.setNodeHostnameEntities(null);
		} else {
			List<NodeHostnameEntity> list = this.getNodeHostnameEntities();
			Iterator<NodeHostnameEntity> iter = list.iterator();
			while(iter.hasNext()) {
				NodeHostnameEntity entity = iter.next();
				if (!notDelPkList.contains(entity.getId())) {
					iter.remove();
				}
			}
		}
	}

	/**
	 * NodeMemoryEntity削除<BR>
	 * 
	 * 指定されたPK以外の子Entityを削除する。
	 * 
	 */
	public void deleteNodeMemoryEntities(List<NodeMemoryEntityPK> notDelPkList) {
		if (notDelPkList == null || notDelPkList.size() == 0) {
			this.setNodeMemoryEntities(null);
		} else {
			List<NodeMemoryEntity> list = this.getNodeMemoryEntities();
			Iterator<NodeMemoryEntity> iter = list.iterator();
			while(iter.hasNext()) {
				NodeMemoryEntity entity = iter.next();
				if (!notDelPkList.contains(entity.getId())) {
					iter.remove();
				}
			}
		}
	}

	/**
	 * NodeNetworkInterfaceEntity削除<BR>
	 * 
	 * 指定されたPK以外の子Entityを削除する。
	 * 
	 */
	public void deleteNodeNetworkInterfaceEntities(List<NodeNetworkInterfaceEntityPK> notDelPkList) {
		if (notDelPkList == null || notDelPkList.size() == 0) {
			this.setNodeNetworkInterfaceEntities(null);
		} else {
			List<NodeNetworkInterfaceEntity> list = this.getNodeNetworkInterfaceEntities();
			Iterator<NodeNetworkInterfaceEntity> iter = list.iterator();
			while(iter.hasNext()) {
				NodeNetworkInterfaceEntity entity = iter.next();
				if (!notDelPkList.contains(entity.getId())) {
					iter.remove();
				}
			}
		}
	}

	/**
	 * NodeNoteEntity削除<BR>
	 * 
	 * 指定されたPK以外の子Entityを削除する。
	 * 
	 */
	public void deleteNodeNoteEntities(List<NodeNoteEntityPK> notDelPkList) {
		if (notDelPkList == null || notDelPkList.size() == 0) {
			this.setNodeNoteEntities(null);
		} else {
			List<NodeNoteEntity> list = this.getNodeNoteEntities();
			Iterator<NodeNoteEntity> iter = list.iterator();
			while(iter.hasNext()) {
				NodeNoteEntity entity = iter.next();
				if (!notDelPkList.contains(entity.getId())) {
					iter.remove();
				}
			}
		}
	}

	/**
	 * NodeVariableEntity削除<BR>
	 * 
	 * 指定されたPK以外の子Entityを削除する。
	 * 
	 */
	public void deleteNodeVariableEntities(List<NodeVariableEntityPK> notDelPkList) {
		if (notDelPkList == null || notDelPkList.size() == 0) {
			this.setNodeVariableEntities(null);
		} else {
			List<NodeVariableEntity> list = this.getNodeVariableEntities();
			Iterator<NodeVariableEntity> iter = list.iterator();
			while(iter.hasNext()) {
				NodeVariableEntity entity = iter.next();
				if (!notDelPkList.contains(entity.getId())) {
					iter.remove();
				}
			}
		}
	}


}